/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.server.world;

import com.minelittlepony.unicopia.Unicopia;
import com.minelittlepony.unicopia.entity.mob.StormCloudEntity;
import com.minelittlepony.unicopia.server.world.WorldOverlay;
import com.minelittlepony.unicopia.util.MeteorlogicalUtil;
import com.minelittlepony.unicopia.util.Tickable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public class WeatherConditions
extends class_18
implements Tickable {
    public static final double FIRE_UPDRAFT = 0.13;
    public static final double SAND_UPDRAFT = 0.03;
    public static final double SOUL_SAND_UPDRAFT = -0.03;
    public static final double ICE_UPDRAFT = 0.0;
    public static final double VOID_UPDRAFT = -0.23;
    public static final float MAX_UPDRAFT_HEIGHT = 20.0f;
    public static final float MAX_TERRAIN_HEIGHT = 50.0f;
    public static final float MAX_WIND_HEIGHT = 70.0f;
    public static final Plane HEIGHT_MAP_FIELD = (world, pos) -> world.method_8624(class_2902.class_2903.field_13194, pos.method_10263(), pos.method_10260());
    public static final Plane THERMAL_FIELD = (world, pos) -> {
        double factor = 1.0f - WeatherConditions.getScaledDistanceFromTerrain(pos, world, 20.0f);
        return (float)(factor * WeatherConditions.getMaterialSurfaceTemperature(pos, world));
    };
    public static final Plane LOCAL_ALTITUDE_FIELD = (world, pos) -> {
        if (!world.method_22347((class_2338)pos)) {
            return 0.0f;
        }
        int y = pos.method_10264();
        do {
            pos.method_10098(class_2350.field_11033);
        } while (world.method_22347((class_2338)pos) && world.method_24794((class_2338)pos));
        return y - pos.method_10264();
    };
    private static final class_2960 ID = Unicopia.id("weather_conditions");
    private final class_1937 world;
    private float windYaw;
    private float prevWindYaw;
    private int interpolation;
    private int maxInterpolation = 100;
    private boolean prevDayState;
    private Map<UUID, Storm> storms = new HashMap<UUID, Storm>();

    public static WeatherConditions get(class_1937 world) {
        return WorldOverlay.getPersistableStorage(world, ID, WeatherConditions::new, WeatherConditions::new);
    }

    private WeatherConditions(class_1937 world, class_2487 compound) {
        this(world);
        this.windYaw = compound.method_10583("windYaw");
        this.prevWindYaw = compound.method_10583("prevWindYaw");
        this.prevDayState = compound.method_10577("prevDayState");
        this.interpolation = compound.method_10550("interpolation");
        this.maxInterpolation = compound.method_10550("maxInterpolation");
    }

    private WeatherConditions(class_1937 world) {
        this.world = world;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStorm(StormCloudEntity cloud) {
        Map<UUID, Storm> map = this.storms;
        synchronized (map) {
            this.storms.computeIfAbsent(cloud.method_5667(), id -> new Storm(this, cloud));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInRangeOfStorm(class_2338 pos) {
        Map<UUID, Storm> map = this.storms;
        synchronized (map) {
            this.storms.values().removeIf(Storm::shouldRemove);
            return this.storms.values().stream().anyMatch(storm -> storm.inRange(pos));
        }
    }

    @Override
    public void tick() {
        boolean isDay;
        if (this.interpolation < this.maxInterpolation) {
            ++this.interpolation;
            this.method_80();
        }
        if ((isDay = this.world.method_8530()) != this.prevDayState || this.world.field_9229.method_43048(1200) == 0 || this.world.method_8419() && this.world.field_9229.method_43048(120) == 0 || this.world.method_8546() && this.world.field_9229.method_43048(90) == 0) {
            this.prevDayState = isDay;
            this.prevWindYaw = this.getWindYaw();
            this.windYaw = this.world.field_9229.method_43057() * 360.0f;
            this.interpolation = 0;
            this.maxInterpolation = this.world.method_8419() || this.world.method_8546() ? 50 : 100;
            this.method_80();
        }
    }

    public float getWindYaw() {
        return class_3532.method_16439((float)((float)this.interpolation / (float)this.maxInterpolation), (float)this.prevWindYaw, (float)this.windYaw);
    }

    public int getWindInterpolation() {
        return this.interpolation;
    }

    public class_243 getWindDirection() {
        return class_243.method_1030((float)0.0f, (float)this.getWindYaw()).method_1029();
    }

    public class_2487 method_75(class_2487 compound, class_7225.class_7874 lookup) {
        compound.method_10548("windYaw", this.windYaw);
        compound.method_10548("prevWindYaw", this.prevWindYaw);
        compound.method_10556("prevDayState", this.prevDayState);
        compound.method_10569("interpolation", this.interpolation);
        compound.method_10569("maxInterpolation", this.maxInterpolation);
        return compound;
    }

    public static class_243 getAirflow(class_2338 pos, class_1937 world) {
        class_2338.class_2339 probedPosition = new class_2338.class_2339();
        float terrainFactor = WeatherConditions.getScaledDistanceFromTerrain(probedPosition.method_10101((class_2382)pos), world, 50.0f);
        float windFactor = WeatherConditions.getScaledDistanceFromTerrain(probedPosition.method_10101((class_2382)pos), world, 70.0f);
        class_243 terrainGradient = LOCAL_ALTITUDE_FIELD.computeAverage(world, pos, probedPosition).method_1021((double)(1.0f - terrainFactor));
        class_243 thermalGradient = THERMAL_FIELD.computeAverage(world, pos, probedPosition).method_1021((double)(1.0f - terrainFactor));
        class_243 wind = WeatherConditions.get(world).getWindDirection().method_1021((double)windFactor);
        return terrainGradient.method_1019(thermalGradient).method_1019(wind).method_1029().method_1021((double)windFactor);
    }

    private static float getScaledDistanceFromTerrain(class_2338.class_2339 pos, class_1937 world, float maxDistance) {
        return Math.min(maxDistance, LOCAL_ALTITUDE_FIELD.getValue(world, pos)) / maxDistance;
    }

    private static double getMaterialSurfaceTemperature(class_2338.class_2339 pos, class_1937 world) {
        class_2680 state = world.method_8320((class_2338)pos);
        if (state.method_26215()) {
            return -0.23;
        }
        if (state.method_27852(class_2246.field_10114) || state.method_27852(class_2246.field_22090)) {
            return -0.03;
        }
        if (state.method_27852(class_2246.field_10164) || state.method_27852(class_2246.field_27098) || state.method_26164(class_3481.field_21952) || state.method_26164(class_3481.field_23799) || state.method_27852(class_2246.field_10092)) {
            return 0.13;
        }
        if (state.method_26164(class_3481.field_15466)) {
            return 0.03 * (double)MeteorlogicalUtil.getSunIntensity(world);
        }
        if (state.method_26164(class_3481.field_29823) || state.method_26164(class_3481.field_15467)) {
            return 0.0 * (double)MeteorlogicalUtil.getSunIntensity(world);
        }
        if (state.method_26227().method_15767(class_3486.field_15517)) {
            int depth;
            float sunIntensity = MeteorlogicalUtil.getSunIntensity(world);
            class_2338.class_2339 mutable = pos.method_25503();
            for (depth = 0; depth < 15 && world.method_8316((class_2338)mutable).method_15767(class_3486.field_15517); ++depth) {
                mutable.method_10098(class_2350.field_11033);
            }
            return sunIntensity * ((float)depth / 15.0f);
        }
        return 0.0;
    }

    public static class_243 getGustStrength(class_1937 world, class_2338 pos) {
        class_5819 random = WeatherConditions.getPositionalRandom(world, pos);
        float strength = 0.015f * random.method_43057();
        if (random.method_43048(30) == 0) {
            strength *= 10.0f;
        }
        if (random.method_43048(30) == 0) {
            strength *= 10.0f;
        }
        if (random.method_43048(40) == 0) {
            strength *= 100.0f;
        }
        strength = Math.min(strength, 7.0f);
        float pitch = 180.0f * random.method_43057() - 90.0f;
        float yaw = 180.0f * random.method_43057() - 90.0f;
        return new class_243((double)(strength * world.method_8430(1.0f)), (double)pitch, (double)yaw);
    }

    public static class_5819 getPositionalRandom(class_1937 world, class_2338 pos) {
        long posLong = class_1923.method_37232((class_2338)pos);
        long time = world.method_8510();
        return class_5819.method_43049((long)(posLong + time));
    }

    public static interface Plane {
        public float getValue(class_1937 var1, class_2338.class_2339 var2);

        default public class_243 computedAverage(class_1937 world, class_2338 pos) {
            return this.computeAverage(world, pos, new class_2338.class_2339());
        }

        default public class_243 computeAverage(class_1937 world, class_2338 pos, class_2338.class_2339 probedPosition) {
            float e = this.getValue(world, probedPosition.method_10101((class_2382)pos));
            int projectionDistance = 4;
            class_243 def = new class_243((double)(-Plane.average(this.getValue(world, probedPosition.method_10103(pos.method_10263() - projectionDistance, pos.method_10264(), pos.method_10260())) - e, e - this.getValue(world, probedPosition.method_10103(pos.method_10263() + projectionDistance, pos.method_10264(), pos.method_10260())))), 0.0, 0.0).method_1029();
            class_243 beh = new class_243(0.0, 0.0, (double)(-Plane.average(this.getValue(world, probedPosition.method_10103(pos.method_10263(), pos.method_10264(), pos.method_10260() - projectionDistance)) - e, e - this.getValue(world, probedPosition.method_10103(pos.method_10263(), pos.method_10264(), pos.method_10260() + projectionDistance))))).method_1029();
            double diagMag = Plane.average(this.getValue(world, probedPosition.method_10103(pos.method_10263() - projectionDistance, pos.method_10264(), pos.method_10260() - projectionDistance)) - e, e - this.getValue(world, probedPosition.method_10103(pos.method_10263() + projectionDistance, pos.method_10264(), pos.method_10260() + projectionDistance)));
            class_243 aei = new class_243(0.5 * diagMag, 0.0, 0.5 * diagMag).method_1029();
            diagMag = Plane.average(this.getValue(world, probedPosition.method_10103(pos.method_10263() - projectionDistance, pos.method_10264(), pos.method_10260() + projectionDistance)) - e, e - this.getValue(world, probedPosition.method_10103(pos.method_10263() + projectionDistance, pos.method_10264(), pos.method_10260() - projectionDistance)));
            class_243 gec = new class_243(0.5 * diagMag, 0.0, 0.5 * diagMag).method_1029();
            return beh.method_1019(def).method_1019(aei).method_1019(gec).method_1029();
        }

        private static float average(float a, float b) {
            return (a + b) / 2.0f;
        }
    }

    private class Storm {
        private final WeakReference<StormCloudEntity> cloud;

        public Storm(WeatherConditions weatherConditions, StormCloudEntity cloud) {
            this.cloud = new WeakReference<StormCloudEntity>(cloud);
        }

        public boolean inRange(class_2338 pos) {
            StormCloudEntity cloud = (StormCloudEntity)this.cloud.get();
            if (cloud == null) {
                return false;
            }
            class_2338 cloudPos = cloud.method_24515();
            if ((float)pos.method_10264() > (float)cloudPos.method_10264() + cloud.method_17682()) {
                return false;
            }
            float radius = cloud.getSizeInBlocks();
            return (float)(cloudPos.method_10263() - pos.method_10263()) <= radius && (float)(cloudPos.method_10260() - pos.method_10260()) <= radius;
        }

        public boolean shouldRemove() {
            StormCloudEntity cloud = (StormCloudEntity)this.cloud.get();
            return cloud == null || cloud.method_31481() || !cloud.isStormy();
        }
    }
}

