/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.util;

import com.minelittlepony.unicopia.util.PsyFluidHelper;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3545;
import net.minecraft.class_3610;

public interface FluidHelper {
    public static class_3610 getFullFluidState(FluidVariant variant) {
        return PsyFluidHelper.getFullFluidState(variant);
    }

    public static Optional<class_3545<Long, FluidVariant>> extract(class_1799 stack, class_1657 player, class_1268 hand) {
        return FluidHelper.getAsContainer(stack, ContainerItemContext.forPlayerInteraction((class_1657)player, (class_1268)hand)).filter(c -> !c.isResourceBlank()).map(container -> FluidHelper.applyTransaction(t -> {
            FluidVariant type = (FluidVariant)container.getResource();
            long amountExtracted = container.extract((Object)type, 81000L, (TransactionContext)t);
            if (amountExtracted > 0L) {
                return new class_3545((Object)amountExtracted, (Object)type);
            }
            return null;
        }));
    }

    public static long deposit(class_1799 stack, class_1657 player, class_1268 hand, FluidVariant variant, long amount) {
        return amount - FluidHelper.getAsStorage(stack, ContainerItemContext.forPlayerInteraction((class_1657)player, (class_1268)hand)).map(storage -> FluidHelper.applyTransaction(t -> storage.insert((Object)variant, amount, (TransactionContext)t))).orElse(0L);
    }

    private static Optional<Storage<FluidVariant>> getAsStorage(class_1799 stack, ContainerItemContext context) {
        return Optional.ofNullable((Storage)FluidStorage.ITEM.find(stack, (Object)context));
    }

    private static Optional<StorageView<FluidVariant>> getAsContainer(class_1799 stack, ContainerItemContext context) {
        return FluidHelper.getAsStorage(stack, context).map(storage -> {
            Iterator iter = storage.iterator();
            return iter.hasNext() ? (StorageView)iter.next() : null;
        });
    }

    private static <T> T applyTransaction(Function<Transaction, T> action) {
        try (Transaction transaction = Transaction.isOpen() ? Transaction.getCurrentUnsafe().openNested() : Transaction.openOuter();){
            T t;
            try {
                t = action.apply(transaction);
            }
            catch (Throwable throwable) {
                transaction.commit();
                throw throwable;
            }
            transaction.commit();
            return t;
        }
    }
}

