/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.util;

import com.minelittlepony.unicopia.client.UnicopiaClient;
import com.minelittlepony.unicopia.server.world.UnicopiaWorldProperties;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public interface MeteorlogicalUtil {
    public static final float SUNRISE = 0.0f;
    public static final float NOON = 0.5f;
    public static final float SUNSET = 1.0f;
    public static final float MIDNIGHT = 1.5f;
    public static final float MOONSET = 2.0f;

    public static boolean isBetween(float skyAngle, float start, float end) {
        return skyAngle >= start && skyAngle <= end;
    }

    public static boolean isLookingIntoSun(class_1937 world, class_1297 entity) {
        if (!world.method_8597().comp_642()) {
            return false;
        }
        if (world.method_8520(entity.method_24515()) || world.method_8546()) {
            return false;
        }
        float skyAngle = MeteorlogicalUtil.getSkyAngle(entity.method_37908());
        float playerYaw = class_3532.method_15393((float)entity.method_5791());
        float playerAngle = -entity.method_5695(1.0f) / 90.0f / 2.0f;
        if (playerYaw > 0.0f) {
            playerAngle = 1.0f - playerAngle;
        }
        playerYaw = world.method_8608() ? (playerYaw += UnicopiaClient.getInstance().tangentalSkyAngle.getValue()) : (playerYaw += UnicopiaWorldProperties.forWorld((class_3218)world).getTangentalSkyAngle());
        playerYaw = Math.abs(playerYaw);
        return skyAngle < 1.0f && (playerYaw > 89.0f && playerYaw < 92.0f || playerAngle > 0.45f && playerAngle < 0.55f) && playerAngle > skyAngle - 0.04f && playerAngle < skyAngle + 0.04f && entity.method_5745(100.0, 1.0f, true).method_17783() == class_239.class_240.field_1333;
    }

    public static float getSunIntensity(class_1937 world) {
        float skyAngle = MeteorlogicalUtil.getSkyAngle(world);
        if (skyAngle > 1.0f) {
            return 0.0f;
        }
        float intensity = class_3532.method_15362((float)((skyAngle - 0.5f) * (float)Math.PI));
        if (world.method_8419()) {
            intensity = (float)((double)intensity * 0.5);
        }
        if (world.method_8546()) {
            intensity = (float)((double)intensity * 0.5);
        }
        return intensity;
    }

    public static float getSkyAngle(class_1937 world) {
        return (world.method_30274(1.0f) + 0.25f) % 1.0f * 2.0f;
    }

    public static boolean isPositionExposedToSun(class_1937 world, class_2338 pos) {
        if (world.field_9236) {
            world.method_8533();
        }
        return world.method_8597().comp_642() && world.method_8314(class_1944.field_9284, pos) >= 12 && !world.method_8419() && !world.method_8546() && world.method_8530();
    }
}

