/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.util;

import com.google.common.base.Suppliers;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

final class PsyFluidHelper {
    private static final Supplier<Optional<Class<?>>> SIMPLE_FLUID_CLASS = Suppliers.memoize(() -> {
        try {
            return Optional.ofNullable(Class.forName("ivorius.psychedelicraft.fluid.SimpleFluid"));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    });
    private static final Supplier<Optional<Class<?>>> ITEM_FLUIDS_CLASS = Suppliers.memoize(() -> {
        try {
            return Optional.ofNullable(Class.forName("ivorius.psychedelicraft.item.component.ItemFluids"));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    });
    private static final Function<FluidVariant, class_3610> FALLBACK_METHOD = fluid -> fluid.getFluid().method_15785();
    private static final Supplier<Function<FluidVariant, class_3610>> GET_FULL_FLUID_STATE = Suppliers.memoize(() -> SIMPLE_FLUID_CLASS.get().map(type -> ITEM_FLUIDS_CLASS.get().map(fluidsType -> {
        try {
            Method method;
            class_9331 fluidsComponentType = (class_9331)class_7923.field_49658.method_10223(class_2960.method_60655((String)"psychedelicraft", (String)"fluids"));
            if (fluidsComponentType != null && (method = type.getDeclaredMethod("getFluidState", (Class<?>)fluidsType)) != null) {
                return fluidVariant -> {
                    try {
                        Object fluids = fluidVariant.getComponents().method_57845(fluidsComponentType).orElse(null);
                        if (fluids == null) {
                            return FALLBACK_METHOD.apply((FluidVariant)fluidVariant);
                        }
                        return (class_3610)method.invoke(type.cast(fluidVariant), fluids);
                    }
                    catch (Throwable throwable) {
                        return FALLBACK_METHOD.apply((FluidVariant)fluidVariant);
                    }
                };
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return FALLBACK_METHOD;
    }).orElse(FALLBACK_METHOD)).orElse(FALLBACK_METHOD));

    PsyFluidHelper() {
    }

    static class_3610 getFullFluidState(FluidVariant variant) {
        return SIMPLE_FLUID_CLASS.get().filter(type -> type.isAssignableFrom(variant.getFluid().getClass())).map(type -> GET_FULL_FLUID_STATE.get().apply(variant)).orElseGet(() -> variant.getFluid().method_15785());
    }
}

