/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.util.shape;

import com.minelittlepony.unicopia.util.shape.Shape;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.spongepowered.include.com.google.common.base.Objects;

public class Sphere
implements Shape {
    public static final Sphere UNIT_SPHERE = new Sphere(false, 1.0);
    protected final class_243 stretch;
    private final boolean hollow;
    private final double rad;
    private final double volume;

    public Sphere(boolean hollow, double radius) {
        this(hollow, radius, 1.0f, 1.0f, 1.0f);
    }

    public Sphere(boolean hollow, double radius, float stretchX, float stretchY, float stretchZ) {
        this.hollow = hollow;
        this.stretch = new class_243((double)stretchX, (double)stretchY, (double)stretchZ);
        this.rad = radius;
        this.volume = this.computeSpawnableSpace();
    }

    @Override
    public double getVolume() {
        return this.volume;
    }

    private double computeSpawnableSpace() {
        if (!this.hollow) {
            return Sphere.computeEllipsoidVolume(this.rad, this.stretch);
        }
        if (this.stretch.field_1352 == this.stretch.field_1351 && this.stretch.field_1351 == this.stretch.field_1350) {
            double radius = this.rad * this.stretch.field_1352;
            return Math.PI * 4 * radius * radius;
        }
        return Sphere.computeEllipsoidArea(this.rad, this.stretch);
    }

    @Override
    public class_243 computePoint(class_5819 rand) {
        double rad = this.rad;
        if (!this.hollow) {
            rad = class_3532.method_15366((class_5819)rand, (double)0.0, (double)rad);
        }
        double z = class_3532.method_15366((class_5819)rand, (double)(-rad), (double)rad);
        double phi = class_3532.method_15366((class_5819)rand, (double)0.0, (double)(Math.PI * 2));
        double theta = Math.asin(z / rad);
        return new class_243(rad * Math.cos(theta) * Math.cos(phi) * this.stretch.field_1352, rad * Math.cos(theta) * Math.sin(phi) * this.stretch.field_1351, z * this.stretch.field_1350);
    }

    @Override
    public boolean isPointInside(class_243 point) {
        point = new class_243(point.field_1352 / this.stretch.field_1352, point.field_1351 / this.stretch.field_1351, point.field_1350 / this.stretch.field_1350);
        double dist = point.method_1033();
        return this.hollow ? dist == this.rad : dist <= this.rad;
    }

    @Override
    public class_243 getLowerBound() {
        return this.stretch.method_1021(-this.rad);
    }

    @Override
    public class_243 getUpperBound() {
        return this.stretch.method_1021(this.rad);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof Sphere)) return false;
        Sphere o = (Sphere)other;
        if (!Objects.equal((Object)this.stretch, (Object)o.stretch)) return false;
        if (this.hollow != o.hollow) return false;
        if (Double.compare(this.rad, o.rad) != 0) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.stretch, this.hollow, this.rad});
    }

    public static double computeEllipsoidArea(double rad, class_243 stretch) {
        double p = 1.6075;
        double result = Math.pow(rad * stretch.field_1352, p) * Math.pow(rad * stretch.field_1351, p);
        result += Math.pow(rad * stretch.field_1352, p) * Math.pow(rad * stretch.field_1350, p);
        result += Math.pow(rad * stretch.field_1351, p) * Math.pow(rad * stretch.field_1351, p);
        return Math.PI * 2 * Math.pow(result /= 3.0, 1.0 / p);
    }

    public static double computeEllipsoidVolume(double rad, class_243 stretch) {
        double result = Math.PI;
        result *= rad * stretch.field_1352;
        result *= rad * stretch.field_1351;
        return result *= rad * stretch.field_1350;
    }
}

