/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import java.util.Objects;
import net.minecraft.class_1058;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1767;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_327;
import net.minecraft.class_4581;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_761;

public class DisplayBlockEntityRenderer
implements CustomBlockEntityRenderer<DisplayBlockEntity> {
    private static final double TEXT_RENDER_DISTANCE = 225.0;

    public void render(DisplayBlockEntity entity, float partialTicks, class_4587 poseStack, class_4597 bufferSource, int combinedLight, int combinedOverlay) {
        double platformY;
        if (!entity.isBottomDisplay() || !entity.getInputBlockEntity().hasGroup()) {
            return;
        }
        class_4588 buffer = bufferSource.getBuffer(class_1921.method_23581());
        int height = entity.hasDisplayOnTop() ? 2 : 1;
        class_1937 level = entity.method_10997();
        class_2350 facing = entity.getFacing();
        ElevatorGroup group = entity.getElevatorGroup();
        class_2338 frontPos = entity.method_11016().method_10093(facing);
        if (height == 1) {
            combinedLight = class_761.method_23794((class_1920)level, (class_2338)frontPos);
        } else if (level.method_8320(frontPos).method_26208((class_1922)level, frontPos) || level.method_8320(frontPos.method_10084()).method_26208((class_1922)level, frontPos.method_10084())) {
            combinedLight = 0xF000F0;
        } else {
            int skyLight = Math.max(level.method_8314(class_1944.field_9284, frontPos), level.method_8314(class_1944.field_9284, frontPos.method_10084()));
            int blockLight = Math.max(level.method_8314(class_1944.field_9282, frontPos), level.method_8314(class_1944.field_9282, frontPos.method_10084()));
            int blockStateLight = Math.max(level.method_8320(frontPos).method_26213(), level.method_8320(frontPos.method_10084()).method_26213());
            blockLight = Math.max(blockLight, blockStateLight);
            combinedLight = skyLight << 20 | blockLight << 4;
        }
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(new class_1158(0.0f, 180.0f - facing.method_10144(), 0.0f, true));
        poseStack.method_22904(-0.5, -0.5, -0.51);
        if (height == 1) {
            this.drawOverlayPart(poseStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, 0, 32, 32);
        } else {
            this.drawOverlayPart(poseStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 2.0f, 32, 0, 32, 64);
        }
        int index = group.getFloorNumber(entity.getInputBlockEntity().getFloorLevel());
        int button_count = height == 1 ? 3 : 7;
        int below = index;
        int above = group.getFloorCount() - index - 1;
        if (below < above) {
            below = Math.min(below, button_count);
            above = Math.min(above, button_count * 2 - below);
        } else {
            above = Math.min(above, button_count);
            below = Math.min(below, button_count * 2 - above);
        }
        int startIndex = index - below;
        int total = below + 1 + above;
        class_243 buttonPos = new class_243((double)entity.method_11016().method_10263() + 0.5, (double)entity.method_11016().method_10264() + 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0, (double)entity.method_11016().method_10260() + 0.5);
        class_243 cameraPos = RenderUtils.getCameraPosition();
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0, -0.002);
        poseStack.method_22905(1.0f, 0.125f, 1.0f);
        for (int i = 0; i < total; ++i) {
            boolean drawText;
            class_1767 labelColor = group.getFloorDisplayColor(startIndex + i);
            this.drawOverlayPart(poseStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, startIndex + i == index ? 96 : 64, labelColor.method_7789() * 4, 32, 4);
            boolean bl = drawText = cameraPos.method_1025(buttonPos) < 225.0;
            if (drawText) {
                poseStack.method_22903();
                poseStack.method_22904(0.578125, 0.0, 0.0);
                this.drawString(poseStack, bufferSource, combinedLight, MovingElevatorsClient.formatFloorDisplayName(group.getFloorDisplayName(startIndex + i), startIndex + i));
                poseStack.method_22909();
            }
            poseStack.method_22904(0.0, 1.0, 0.0);
            buttonPos = buttonPos.method_1031(0.0, 0.125, 0.0);
        }
        poseStack.method_22909();
        if (group.isMoving() && (platformY = group.getCurrentY()) >= (double)group.getFloorYLevel(0) && platformY < (double)group.getFloorYLevel(group.getFloorCount() - 1)) {
            double yOffset = 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0;
            for (int i = 0; i < group.getFloorCount() - 1; ++i) {
                int belowY = group.getFloorYLevel(i);
                int aboveY = group.getFloorYLevel(i + 1);
                if (!(platformY >= (double)belowY) || !(platformY < (double)aboveY)) continue;
                yOffset += ((double)i + (platformY - (double)belowY) / (double)(aboveY - belowY)) * 0.125;
            }
            poseStack.method_22904(0.078125, yOffset, -0.003);
            poseStack.method_22905(0.125f, 0.125f, 1.0f);
            this.drawOverlayPart(poseStack, buffer, combinedLight, combinedOverlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, 32, 10, 10);
        }
        poseStack.method_22909();
    }

    private void drawOverlayPart(class_4587 poseStack, class_4588 buffer, int combinedLight, int combinedOverlay, class_2350 facing, float x, float y, float width, float height, int tX, int tY, int tWidth, int tHeight) {
        class_1159 matrix = poseStack.method_23760().method_23761();
        class_4581 normalMatrix = poseStack.method_23760().method_23762();
        class_1058 overlaySprite = MovingElevatorsClient.getOverlaySprite();
        float minU = overlaySprite.method_4580((double)((float)tX / 8.0f));
        float maxU = overlaySprite.method_4580((double)((float)(tX + tWidth) / 8.0f));
        float minV = overlaySprite.method_4570((double)((float)tY / 8.0f));
        float maxV = overlaySprite.method_4570((double)((float)(tY + tHeight) / 8.0f));
        buffer.method_22918(matrix, x, y + height, 0.0f).method_1336(255, 255, 255, 255).method_22913(maxU, minV).method_22916(combinedLight).method_23763(normalMatrix, (float)facing.method_10148(), (float)facing.method_10164(), (float)facing.method_10165()).method_22922(combinedOverlay).method_1344();
        buffer.method_22918(matrix, x + width, y + height, 0.0f).method_1336(255, 255, 255, 255).method_22913(minU, minV).method_22916(combinedLight).method_23763(normalMatrix, (float)facing.method_10148(), (float)facing.method_10164(), (float)facing.method_10165()).method_22922(combinedOverlay).method_1344();
        buffer.method_22918(matrix, x + width, y, 0.0f).method_1336(255, 255, 255, 255).method_22913(minU, maxV).method_22916(combinedLight).method_23763(normalMatrix, (float)facing.method_10148(), (float)facing.method_10164(), (float)facing.method_10165()).method_22922(combinedOverlay).method_1344();
        buffer.method_22918(matrix, x, y, 0.0f).method_1336(255, 255, 255, 255).method_22913(maxU, maxV).method_22916(combinedLight).method_23763(normalMatrix, (float)facing.method_10148(), (float)facing.method_10164(), (float)facing.method_10165()).method_22922(combinedOverlay).method_1344();
    }

    private void drawString(class_4587 poseStack, class_4597 buffer, int combinedLight, String s) {
        if (s == null) {
            return;
        }
        class_327 fontRenderer = ClientUtils.getMinecraft().field_1772;
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.07, -0.005);
        poseStack.method_22905(-0.01f, -0.08f, 1.0f);
        float f = (float)(-fontRenderer.method_1727(s)) / 2.0f;
        Objects.requireNonNull(fontRenderer);
        fontRenderer.method_1729(poseStack, s, f, (float)(-9), -1);
        poseStack.method_22909();
    }
}

