/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui.preview;

import com.mojang.blaze3d.systems.RenderSystem;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.movingelevators.gui.preview.WorldBlockCapture;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1087;
import net.minecraft.class_1158;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_308;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_777;

public class ElevatorPreviewRenderer {
    public static void renderPreview(WorldBlockCapture capture, class_238 cabinBox, class_238 previewBox, double x, double y, double scale, float yaw, float pitch, boolean doShading) {
        class_238 bounds = capture.getBounds();
        class_243 center = bounds.method_1005();
        double span = Math.sqrt(bounds.method_17939() * bounds.method_17939() + bounds.method_17940() * bounds.method_17940() + bounds.method_17941() * bounds.method_17941());
        scale /= span;
        RenderSystem.getModelViewStack().method_22903();
        RenderSystem.getModelViewStack().method_22905(1.0f, -1.0f, 1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 poseStack = new class_4587();
        poseStack.method_22904(x, -y, 350.0);
        poseStack.method_22905((float)scale, (float)scale, (float)scale);
        poseStack.method_22907(new class_1158(pitch, yaw, 0.0f, true));
        poseStack.method_22904(-center.field_1352, -center.field_1351, -center.field_1350);
        if (doShading) {
            class_308.method_24211();
        }
        class_4597.class_4598 renderTypeBuffer = RenderUtils.getMainBufferSource();
        for (class_2338 pos : capture.getBlockLocations()) {
            ElevatorPreviewRenderer.renderBlock(capture, pos, poseStack, (class_4597)renderTypeBuffer);
        }
        renderTypeBuffer.method_22993();
        RenderSystem.enableDepthTest();
        if (doShading) {
            class_308.method_24210();
        }
        RenderUtils.renderBox((class_4587)poseStack, (class_238)cabinBox, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f, (boolean)true);
        if (previewBox != null) {
            RenderUtils.renderBox((class_4587)poseStack, (class_238)previewBox, (float)0.0f, (float)0.7f, (float)0.0f, (float)0.8f, (boolean)true);
        }
        RenderSystem.getModelViewStack().method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    private static void renderBlock(WorldBlockCapture capture, class_2338 pos, class_4587 poseStack, class_4597 renderTypeBuffer) {
        class_2586 blockEntity;
        poseStack.method_22903();
        poseStack.method_22904((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        class_2680 state = capture.getBlockState(pos);
        if (state.method_26204() != class_2246.field_10124) {
            class_1087 model = ClientUtils.getBlockRenderer().method_3349(state);
            class_1921 renderType = class_4696.method_23683((class_2680)state, (boolean)true);
            ElevatorPreviewRenderer.renderModel(model, capture, state, pos, poseStack, renderTypeBuffer.getBuffer(renderType));
        }
        if ((blockEntity = capture.getBlockEntity(pos)) != null) {
            ClientUtils.getMinecraft().method_31975().method_3555(blockEntity, ClientUtils.getPartialTicks(), poseStack, renderTypeBuffer);
        }
        poseStack.method_22909();
    }

    private static void renderModel(class_1087 model, WorldBlockCapture capture, class_2680 state, class_2338 pos, class_4587 poseStack, class_4588 buffer) {
        Random random = new Random();
        for (class_2350 direction : class_2350.values()) {
            random.setSeed(42L);
            ElevatorPreviewRenderer.renderQuads(capture, state, pos, poseStack, buffer, model.method_4707(state, direction, random));
        }
        random.setSeed(42L);
        ElevatorPreviewRenderer.renderQuads(capture, state, pos, poseStack, buffer, model.method_4707(state, null, random));
    }

    private static void renderQuads(WorldBlockCapture capture, class_2680 state, class_2338 pos, class_4587 poseStack, class_4588 buffer, List<class_777> quads) {
        class_4587.class_4665 matrix = poseStack.method_23760();
        for (class_777 bakedquad : quads) {
            float red = 1.0f;
            float blue = 1.0f;
            float green = 1.0f;
            float alpha = 1.0f;
            if (bakedquad.method_3360()) {
                int color = ClientUtils.getMinecraft().method_1505().method_1697(state, (class_1920)capture.getLevel(), pos, bakedquad.method_3359());
                red = (float)(color >> 16 & 0xFF) / 255.0f;
                green = (float)(color >> 8 & 0xFF) / 255.0f;
                blue = (float)(color & 0xFF) / 255.0f;
            }
            buffer.method_22919(matrix, bakedquad, red, green, blue, 0xF000F0, class_4608.field_21444);
        }
    }
}

