/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.render.TextureAtlases;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntityRenderer;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntityRenderer;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.gui.ElevatorScreen;
import com.supermartijn642.movingelevators.model.CamoBakedModel;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class MovingElevatorsClient {
    public static final ResourceLocation OVERLAY_TEXTURE_LOCATION = new ResourceLocation("movingelevators", "blocks/block_overlays");
    public static TextureAtlasSprite OVERLAY_SPRITE;

    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"movingelevators");
        handler.registerCustomBlockEntityRenderer(() -> MovingElevators.elevator_tile, ElevatorInputBlockEntityRenderer::new);
        handler.registerCustomBlockEntityRenderer(() -> MovingElevators.display_tile, DisplayBlockEntityRenderer::new);
        handler.registerCustomBlockEntityRenderer(() -> MovingElevators.button_tile, ElevatorInputBlockEntityRenderer::new);
        handler.registerAtlasSprite(TextureAtlases.getBlocks(), OVERLAY_TEXTURE_LOCATION.m_135815_());
        handler.registerBlockModelOverwrite(() -> MovingElevators.elevator_block, CamoBakedModel::new);
        handler.registerBlockModelOverwrite(() -> MovingElevators.display_block, CamoBakedModel::new);
        handler.registerBlockModelOverwrite(() -> MovingElevators.button_block, CamoBakedModel::new);
        handler.registerBlockModelTranslucentRenderType(() -> MovingElevators.elevator_block);
        handler.registerBlockModelTranslucentRenderType(() -> MovingElevators.display_block);
        handler.registerBlockModelTranslucentRenderType(() -> MovingElevators.button_block);
    }

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent e) {
        ClientUtils.getMinecraft().m_91298_().m_92589_((state, blockAndTintGetter, pos, p_92570_) -> {
            if (blockAndTintGetter == null || pos == null) {
                return 0;
            }
            BlockEntity entity = blockAndTintGetter.m_7702_(pos);
            return entity instanceof CamoBlockEntity && ((CamoBlockEntity)entity).hasCamoState() ? ClientUtils.getMinecraft().m_91298_().m_92577_(((CamoBlockEntity)entity).getCamoState(), blockAndTintGetter, pos, p_92570_) : 0;
        }, new Block[]{MovingElevators.elevator_block, MovingElevators.display_block, MovingElevators.button_block});
    }

    @SubscribeEvent
    public static void onTextureStitchPost(TextureStitchEvent.Post e) {
        if (e.getMap().m_118330_().equals((Object)TextureAtlases.getBlocks())) {
            OVERLAY_SPRITE = e.getMap().m_118316_(OVERLAY_TEXTURE_LOCATION);
        }
    }

    public static void openElevatorScreen(BlockPos pos) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new ElevatorScreen(pos)));
    }

    public static String formatFloorDisplayName(String name, int floor) {
        return name == null ? TextComponents.translation((String)"movingelevators.floor_name", (Object[])new Object[]{TextComponents.number((int)floor).get()}).format() : name;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventListeners {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent e) {
            if (e.phase == TickEvent.Phase.END && !ClientUtils.getMinecraft().m_91104_() && ClientUtils.getWorld() != null) {
                ElevatorGroupCapability.tickWorldCapability(ClientUtils.getWorld());
            }
        }
    }
}

