/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlock;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlockItem;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ControllerBlock
extends ElevatorInputBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public ControllerBlock(BlockProperties properties) {
        super(properties, (BiFunction<BlockPos, BlockState, ? extends ElevatorInputBlockEntity>)((BiFunction<BlockPos, BlockState, ElevatorInputBlockEntity>)ControllerBlockEntity::new));
    }

    @Override
    protected boolean onRightClick(BlockState state, Level level, CamoBlockEntity blockEntity, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (player != null && player.m_21120_(hand).m_41720_() instanceof RemoteControllerBlockItem && blockEntity instanceof ControllerBlockEntity) {
            if (!level.f_46443_) {
                ItemStack stack = player.m_21120_(hand);
                CompoundTag tag = stack.m_41784_();
                tag.m_128359_("controllerDim", level.m_46472_().m_135782_().toString());
                tag.m_128405_("controllerX", pos.m_123341_());
                tag.m_128405_("controllerY", pos.m_123342_());
                tag.m_128405_("controllerZ", pos.m_123343_());
                tag.m_128405_("controllerFacing", ((ControllerBlockEntity)blockEntity).getFacing().m_122416_());
                player.m_5661_((Component)TextComponents.translation((String)"movingelevators.remote_controller.bind").get(), true);
            }
            return true;
        }
        if (super.onRightClick(state, level, blockEntity, pos, player, hand, hitSide, hitLocation)) {
            return true;
        }
        if (state.m_61143_((Property)FACING) != hitSide) {
            if (level.f_46443_) {
                MovingElevatorsClient.openElevatorScreen(pos);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof ControllerBlockEntity && ((ControllerBlockEntity)entity).hasGroup() && ((ControllerBlockEntity)entity).getGroup().isCageAvailableAt((ControllerBlockEntity)entity)) {
            return 15;
        }
        return 0;
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        info.accept((Component)TextComponents.translation((String)"movingelevators.elevator_controller.tooltip").color(ChatFormatting.AQUA).get());
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean p_60519_) {
        BlockEntity entity;
        if (state.m_155947_() && (!state.m_60713_(newState.m_60734_()) || !newState.m_155947_()) && (entity = level.m_7702_(pos)) instanceof ControllerBlockEntity) {
            ((ControllerBlockEntity)entity).onRemove();
        }
        super.m_6810_(state, level, pos, newState, p_60519_);
    }
}

