/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorCabinLevel;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class RemoteControllerBlockEntity
extends ElevatorInputBlockEntity {
    private Direction facing = Direction.NORTH;
    private BlockPos controllerPos = BlockPos.f_121853_;
    private Direction controllerFacing = null;
    private boolean isInCabin = false;
    private int cabinFloorIndex = -1;
    private int groupCheckCounter = 2;
    private ElevatorGroup lastGroup;

    public RemoteControllerBlockEntity(BlockPos pos, BlockState state) {
        super(MovingElevators.button_tile, pos, state);
    }

    @Override
    public void update() {
        super.update();
        --this.groupCheckCounter;
        if (this.groupCheckCounter <= 0) {
            ElevatorGroup group;
            ControllerBlockEntity controller;
            if (this.controllerFacing == null && this.controllerPos != null && (controller = this.getController()) != null) {
                this.controllerFacing = controller.getFacing();
            }
            if ((group = this.getGroup()) != this.lastGroup) {
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
                if (group != null) {
                    group.addComparatorListener(this.getFloorLevel(), this.f_58858_);
                }
                this.lastGroup = group;
            }
            this.calculateInCabin();
            this.groupCheckCounter = 40;
        }
    }

    public void setValues(Direction facing, BlockPos controllerPos, Direction controllerFacing) {
        this.facing = facing;
        this.controllerPos = controllerPos;
        this.controllerFacing = controllerFacing;
        this.dataChanged();
    }

    private void calculateInCabin() {
        if (this.hasGroup()) {
            ElevatorGroup group = this.getGroup();
            for (int floor = 0; floor < group.getFloorCount(); ++floor) {
                int y = group.getFloorYLevel(floor);
                BlockPos min = group.getCageAnchorBlockPos(y);
                if (this.f_58858_.m_123341_() < min.m_123341_() || this.f_58858_.m_123341_() >= min.m_123341_() + group.getCageSizeX() || this.f_58858_.m_123342_() < min.m_123342_() || this.f_58858_.m_123342_() >= min.m_123342_() + group.getCageSizeY() || this.f_58858_.m_123343_() < min.m_123343_() || this.f_58858_.m_123343_() >= min.m_123343_() + group.getCageSizeZ()) continue;
                this.isInCabin = true;
                this.cabinFloorIndex = floor;
                return;
            }
        }
        this.isInCabin = false;
    }

    @Override
    protected CompoundTag writeData() {
        CompoundTag compound = super.writeData();
        compound.m_128405_("facing", this.facing.m_122411_());
        compound.m_128405_("controllerX", this.controllerPos.m_123341_());
        compound.m_128405_("controllerY", this.controllerPos.m_123342_());
        compound.m_128405_("controllerZ", this.controllerPos.m_123343_());
        if (this.controllerFacing != null) {
            compound.m_128405_("controllerFacing", this.controllerFacing.m_122416_());
        }
        this.groupCheckCounter = 2;
        return compound;
    }

    @Override
    protected void readData(CompoundTag compound) {
        super.readData(compound);
        this.facing = Direction.m_122376_((int)compound.m_128451_("facing"));
        this.controllerPos = new BlockPos(compound.m_128451_("controllerX"), compound.m_128451_("controllerY"), compound.m_128451_("controllerZ"));
        this.controllerFacing = compound.m_128425_("controllerFacing", 3) ? Direction.m_122407_((int)compound.m_128451_("controllerFacing")) : null;
        this.isInCabin = false;
    }

    @Override
    public Direction getFacing() {
        return this.facing;
    }

    public ControllerBlockEntity getController() {
        if (this.f_58857_ == null || this.controllerPos == null) {
            return null;
        }
        BlockEntity entity = this.f_58857_.m_7702_(this.controllerPos);
        return entity instanceof ControllerBlockEntity ? (ControllerBlockEntity)entity : null;
    }

    @Override
    public boolean hasGroup() {
        return this.getGroup() != null;
    }

    @Override
    public ElevatorGroup getGroup() {
        ElevatorGroupCapability capability;
        if (this.f_58857_ == null || this.controllerPos == null || this.controllerFacing == null) {
            return null;
        }
        ElevatorGroup group = this.f_58857_ instanceof ElevatorCabinLevel ? ((ElevatorCabinLevel)this.f_58857_).getElevatorGroup() : ((capability = ElevatorGroupCapability.get(this.f_58857_)) == null ? null : capability.get(this.controllerPos.m_123341_(), this.controllerPos.m_123343_(), this.controllerFacing));
        return group != null && group.hasControllerAt(this.controllerPos.m_123342_()) ? group : null;
    }

    @Override
    public String getFloorName() {
        ControllerBlockEntity controller = this.getController();
        return controller == null ? null : controller.getFloorName();
    }

    @Override
    public DyeColor getDisplayLabelColor() {
        ControllerBlockEntity controller = this.getController();
        return controller == null ? null : controller.getDisplayLabelColor();
    }

    @Override
    public int getFloorLevel() {
        if (this.f_58857_ instanceof ElevatorCabinLevel && this.hasGroup()) {
            ElevatorGroup group = this.getGroup();
            return group.getFloorYLevel(group.getClosestFloorNumber(this.f_58858_.m_123342_()));
        }
        if (this.isInCabin && this.hasGroup()) {
            ElevatorGroup group = this.getGroup();
            if (this.cabinFloorIndex >= 0 && this.cabinFloorIndex < group.getFloorCount()) {
                return group.getFloorYLevel(this.cabinFloorIndex);
            }
        }
        return this.controllerPos.m_123342_();
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public void m_7651_() {
        ElevatorGroup group = this.getGroup();
        if (group != null) {
            group.removeComparatorListener(this.f_58858_);
        }
        super.m_7651_();
    }
}

