/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.elevator.ElevatorFallDamageHandler;
import com.supermartijn642.movingelevators.packets.PacketOnElevator;
import java.util.List;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ElevatorCollisionHandler {
    public static void handleEntityCollisions(Level level, AABB bounds, List<AABB> boundingBoxes, Vec3 position, Vec3 motion) {
        bounds = bounds.m_82383_(position);
        bounds = new AABB(bounds.f_82288_, bounds.f_82289_ + Math.min(0.0, motion.f_82480_), bounds.f_82290_, bounds.f_82291_, bounds.f_82292_ + Math.max(0.0, motion.f_82480_), bounds.f_82293_);
        bounds = bounds.m_82400_(2.0);
        List entities = level.m_6249_((Entity)null, bounds, ElevatorCollisionHandler::canCollideWith);
        for (Entity entity : entities) {
            for (AABB box : boundingBoxes) {
                box = box.m_82383_(position);
                ElevatorCollisionHandler.handleHorizontalCollision(entity, box);
            }
            for (AABB box : boundingBoxes) {
                box = box.m_82383_(position);
                ElevatorCollisionHandler.handleVerticalCollision(entity, box, motion);
            }
        }
    }

    private static void handleHorizontalCollision(Entity entity, AABB box) {
        Vec3 entityPos = entity.m_20182_();
        Vec3 oldEntityPos = new Vec3(entity.f_19854_, entity.f_19855_, entity.f_19856_);
        Vec3 entityMotion = entityPos.m_82546_(oldEntityPos);
        AABB entityBox = entity.m_142469_().m_82406_(1.0E-7);
        AABB oldEntityBox = entity.m_142469_().m_82406_(1.0E-7).m_82386_(-entityMotion.f_82479_, 0.0, -entityMotion.f_82481_);
        if (oldEntityBox.f_82292_ > box.f_82289_ && oldEntityBox.f_82289_ < box.f_82292_) {
            if (oldEntityBox.f_82291_ > box.f_82288_ && oldEntityBox.f_82288_ < box.f_82291_) {
                if (oldEntityBox.f_82293_ < box.f_82290_ && entityBox.f_82293_ > box.f_82290_) {
                    entity.m_6034_(entityPos.f_82479_, entityPos.f_82480_, box.f_82290_ - (double)(entity.m_20205_() / 2.0f));
                    entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_, 0.0);
                } else if (oldEntityBox.f_82290_ > box.f_82293_ && entityBox.f_82290_ < box.f_82293_) {
                    entity.m_6034_(entityPos.f_82479_, entityPos.f_82480_, box.f_82293_ + (double)(entity.m_20205_() / 2.0f));
                    entity.m_20334_(entity.m_20184_().f_82479_, entity.m_20184_().f_82480_, 0.0);
                }
            } else if (oldEntityBox.f_82293_ > box.f_82290_ && oldEntityBox.f_82290_ < box.f_82293_) {
                if (oldEntityBox.f_82291_ < box.f_82288_ && entityBox.f_82291_ > box.f_82288_) {
                    entity.m_6034_(box.f_82288_ - (double)(entity.m_20205_() / 2.0f), entityPos.f_82480_, entityPos.f_82481_);
                    entity.m_20334_(0.0, entity.m_20184_().f_82480_, entity.m_20184_().f_82481_);
                } else if (oldEntityBox.f_82288_ > box.f_82291_ && entityBox.f_82288_ < box.f_82291_) {
                    entity.m_6034_(box.f_82291_ + (double)(entity.m_20205_() / 2.0f), entityPos.f_82480_, entityPos.f_82481_);
                    entity.m_20334_(0.0, entity.m_20184_().f_82480_, entity.m_20184_().f_82481_);
                }
            }
        }
    }

    private static void handleVerticalCollision(Entity entity, AABB box, Vec3 motion) {
        AABB newBox = box.m_82383_(motion);
        boolean movingUp = motion.f_82480_ > 0.0;
        Vec3 entityPos = entity.m_20182_();
        Vec3 oldEntityPos = new Vec3(entity.f_19854_, entity.f_19855_, entity.f_19856_);
        Vec3 entityMotion = entityPos.m_82546_(oldEntityPos);
        AABB entityBox = entity.m_142469_().m_82406_(1.0E-7);
        AABB oldEntityBox = entity.m_142469_().m_82406_(1.0E-7).m_82386_(-entityMotion.f_82479_, -entityMotion.f_82480_, -entityMotion.f_82481_);
        if (oldEntityBox.f_82291_ > box.f_82288_ && oldEntityBox.f_82288_ < box.f_82291_ && oldEntityBox.f_82293_ > box.f_82290_ && oldEntityBox.f_82290_ < box.f_82293_) {
            if (oldEntityBox.f_82292_ < box.f_82289_ && entityBox.f_82292_ > newBox.f_82289_) {
                entity.m_6034_(entityPos.f_82479_, newBox.f_82289_ - (double)entity.m_20206_(), entityPos.f_82481_);
                entity.m_20334_(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
            } else if (oldEntityBox.f_82289_ > box.f_82292_ && (entityBox.f_82289_ < newBox.f_82292_ || !movingUp && ElevatorCollisionHandler.canPullEntity(entity) && oldEntityBox.f_82289_ > box.f_82292_ && oldEntityBox.f_82289_ < box.f_82292_ + 0.1)) {
                Player controllingPlayer;
                entity.m_6034_(entityPos.f_82479_, newBox.f_82292_, entityPos.f_82481_);
                entity.m_20334_(entity.m_20184_().f_82479_, 0.0, entity.m_20184_().f_82481_);
                entity.m_6853_(true);
                if (!(entity instanceof LivingEntity) || !ElevatorFallDamageHandler.shouldCancelFallDamage((LivingEntity)entity)) {
                    entity.m_142535_(entity.f_19789_, 1.0f, DamageSource.f_19315_);
                }
                entity.f_19789_ = 0.0f;
                Object object = entity instanceof Player ? (Player)entity : (controllingPlayer = entity.m_6688_() instanceof Player ? (Player)entity.m_6688_() : null);
                if (entity instanceof LivingEntity && controllingPlayer != null) {
                    ElevatorFallDamageHandler.resetElevatorTime((LivingEntity)entity);
                    if (controllingPlayer.m_7578_()) {
                        MovingElevators.CHANNEL.sendToServer((BasePacket)new PacketOnElevator());
                    }
                }
            }
        }
    }

    private static boolean canCollideWith(Entity entity) {
        return !entity.m_5833_() && !entity.f_19794_ && !entity.m_20159_() && entity.m_7752_() == PushReaction.NORMAL;
    }

    private static boolean canPullEntity(Entity entity) {
        return entity.m_20184_().f_82480_ <= 0.0 && !entity.m_20068_();
    }
}

