/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import java.lang.reflect.Field;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ElevatorFallDamageHandler {
    private static final Field floatingTickCount = ObfuscationReflectionHelper.findField(ServerGamePacketListenerImpl.class, (String)"f_9737_");

    @SubscribeEvent
    public static void onFallDamage(LivingFallEvent e) {
        if (ElevatorFallDamageHandler.shouldCancelFallDamage(e.getEntityLiving())) {
            e.setCanceled(true);
        }
    }

    public static boolean shouldCancelFallDamage(LivingEntity entity) {
        CompoundTag compound = entity.getPersistentData();
        if (compound.m_128441_("elevatorTime")) {
            if ((long)entity.f_19797_ - compound.m_128454_("elevatorTime") < 100L) {
                return true;
            }
            compound.m_128473_("elevatorTime");
        }
        return false;
    }

    public static void resetElevatorTime(LivingEntity entity) {
        entity.getPersistentData().m_128356_("elevatorTime", (long)entity.f_19797_);
        if (entity instanceof ServerPlayer) {
            ElevatorFallDamageHandler.resetFloatingTicks((ServerPlayer)entity);
        }
    }

    public static void resetFloatingTicks(ServerPlayer player) {
        try {
            floatingTickCount.setInt(player.f_8906_, 0);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

