/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators;

import com.google.common.collect.Sets;
import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.core.registry.RegistryEntryAcceptor;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.MovingElevatorsConfig;
import com.supermartijn642.movingelevators.blocks.ControllerBlock;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.DisplayBlock;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlock;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.RemoteControllerBlockItem;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import com.supermartijn642.movingelevators.generators.MovingElevatorsAtlasSourceGenerator;
import com.supermartijn642.movingelevators.generators.MovingElevatorsBlockStateGenerator;
import com.supermartijn642.movingelevators.generators.MovingElevatorsItemInfoGenerator;
import com.supermartijn642.movingelevators.generators.MovingElevatorsLanguageGenerator;
import com.supermartijn642.movingelevators.generators.MovingElevatorsLootTableGenerator;
import com.supermartijn642.movingelevators.generators.MovingElevatorsModelGenerator;
import com.supermartijn642.movingelevators.generators.MovingElevatorsRecipeGenerator;
import com.supermartijn642.movingelevators.generators.MovingElevatorsTagGenerator;
import com.supermartijn642.movingelevators.packets.PacketAddElevatorGroup;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinDepth;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinDepthOffset;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinHeight;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinHeightOffset;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinSideOffset;
import com.supermartijn642.movingelevators.packets.PacketDecreaseCabinWidth;
import com.supermartijn642.movingelevators.packets.PacketElevatorSpeed;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinDepth;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinDepthOffset;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinHeight;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinHeightOffset;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinSideOffset;
import com.supermartijn642.movingelevators.packets.PacketIncreaseCabinWidth;
import com.supermartijn642.movingelevators.packets.PacketOnElevator;
import com.supermartijn642.movingelevators.packets.PacketRemoveElevatorGroup;
import com.supermartijn642.movingelevators.packets.PacketSetFloorName;
import com.supermartijn642.movingelevators.packets.PacketSyncElevatorMovement;
import com.supermartijn642.movingelevators.packets.PacketToggleShowControllerButtons;
import com.supermartijn642.movingelevators.packets.PacketUpdateElevatorGroups;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.fml.common.Mod;
import org.slf4j.Logger;

@Mod(value="movingelevators")
public class MovingElevators {
    public static final Set<String> CAMOUFLAGE_MOD_BLACKLIST = Sets.newHashSet((Object[])new String[]{"movingelevators"});
    public static final Logger LOGGER = CommonUtils.getLogger((String)"movingelevators");
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"movingelevators");
    @RegistryEntryAcceptor(namespace="movingelevators", identifier="elevator_block", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static ControllerBlock elevator_block;
    @RegistryEntryAcceptor(namespace="movingelevators", identifier="elevator_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<ControllerBlockEntity> elevator_tile;
    @RegistryEntryAcceptor(namespace="movingelevators", identifier="display_block", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static DisplayBlock display_block;
    @RegistryEntryAcceptor(namespace="movingelevators", identifier="display_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<DisplayBlockEntity> display_tile;
    @RegistryEntryAcceptor(namespace="movingelevators", identifier="button_block", registry=RegistryEntryAcceptor.Registry.BLOCKS)
    public static RemoteControllerBlock button_block;
    @RegistryEntryAcceptor(namespace="movingelevators", identifier="button_tile", registry=RegistryEntryAcceptor.Registry.BLOCK_ENTITY_TYPES)
    public static BaseBlockEntityType<RemoteControllerBlockEntity> button_tile;
    @RegistryEntryAcceptor(namespace="movingelevators", identifier="arrive_sound", registry=RegistryEntryAcceptor.Registry.SOUND_EVENTS)
    public static SoundEvent arrive_sound;
    public static final CreativeItemGroup GROUP;
    public static final boolean isIrisLoaded;

    public MovingElevators() {
        CHANNEL.registerMessage(PacketAddElevatorGroup.class, PacketAddElevatorGroup::new, true);
        CHANNEL.registerMessage(PacketDecreaseCabinDepth.class, PacketDecreaseCabinDepth::new, true);
        CHANNEL.registerMessage(PacketDecreaseCabinDepthOffset.class, PacketDecreaseCabinDepthOffset::new, true);
        CHANNEL.registerMessage(PacketDecreaseCabinHeight.class, PacketDecreaseCabinHeight::new, true);
        CHANNEL.registerMessage(PacketDecreaseCabinHeightOffset.class, PacketDecreaseCabinHeightOffset::new, true);
        CHANNEL.registerMessage(PacketDecreaseCabinSideOffset.class, PacketDecreaseCabinSideOffset::new, true);
        CHANNEL.registerMessage(PacketDecreaseCabinWidth.class, PacketDecreaseCabinWidth::new, true);
        CHANNEL.registerMessage(PacketElevatorSpeed.class, PacketElevatorSpeed::new, true);
        CHANNEL.registerMessage(PacketIncreaseCabinDepth.class, PacketIncreaseCabinDepth::new, true);
        CHANNEL.registerMessage(PacketIncreaseCabinDepthOffset.class, PacketIncreaseCabinDepthOffset::new, true);
        CHANNEL.registerMessage(PacketIncreaseCabinHeight.class, PacketIncreaseCabinHeight::new, true);
        CHANNEL.registerMessage(PacketIncreaseCabinHeightOffset.class, PacketIncreaseCabinHeightOffset::new, true);
        CHANNEL.registerMessage(PacketIncreaseCabinSideOffset.class, PacketIncreaseCabinSideOffset::new, true);
        CHANNEL.registerMessage(PacketIncreaseCabinWidth.class, PacketIncreaseCabinWidth::new, true);
        CHANNEL.registerMessage(PacketOnElevator.class, PacketOnElevator::new, true);
        CHANNEL.registerMessage(PacketRemoveElevatorGroup.class, PacketRemoveElevatorGroup::new, true);
        CHANNEL.registerMessage(PacketSetFloorName.class, PacketSetFloorName::new, true);
        CHANNEL.registerMessage(PacketSyncElevatorMovement.class, PacketSyncElevatorMovement::new, true);
        CHANNEL.registerMessage(PacketToggleShowControllerButtons.class, PacketToggleShowControllerButtons::new, true);
        CHANNEL.registerMessage(PacketUpdateElevatorGroups.class, PacketUpdateElevatorGroups::new, true);
        MovingElevatorsConfig.init();
        ElevatorGroupCapability.registerEventListeners();
        MovingElevators.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            MovingElevatorsClient.register();
        }
        MovingElevators.registerGenerators();
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)"movingelevators");
        Supplier<BlockProperties> properties = () -> BlockProperties.create().mapColor(MapColor.COLOR_GRAY).sound(SoundType.METAL).destroyTime(1.5f).explosionResistance(6.0f);
        handler.registerBlock("elevator_block", () -> new ControllerBlock((BlockProperties)properties.get()));
        handler.registerBlock("display_block", () -> new DisplayBlock((BlockProperties)properties.get()));
        handler.registerBlock("button_block", () -> new RemoteControllerBlock((BlockProperties)properties.get()));
        handler.registerBlockEntityType("elevator_tile", () -> BaseBlockEntityType.create(ControllerBlockEntity::new, (Block[])new Block[]{elevator_block}));
        handler.registerBlockEntityType("display_tile", () -> BaseBlockEntityType.create(DisplayBlockEntity::new, (Block[])new Block[]{display_block}));
        handler.registerBlockEntityType("button_tile", () -> BaseBlockEntityType.create(RemoteControllerBlockEntity::new, (Block[])new Block[]{button_block}));
        handler.registerItem("elevator_block", () -> new BaseBlockItem((Block)elevator_block, ItemProperties.create().group((CreativeModeTab)GROUP)));
        handler.registerItem("display_block", () -> new BaseBlockItem((Block)display_block, ItemProperties.create().group((CreativeModeTab)GROUP)));
        handler.registerItem("button_block", () -> new RemoteControllerBlockItem((Block)button_block, ItemProperties.create().group((CreativeModeTab)GROUP)));
        handler.registerDataComponentType("button_block_target", RemoteControllerBlock.TARGET);
        handler.registerSoundEvent("arrive_sound", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"movingelevators", (String)"arrive_sound")));
    }

    private static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)"movingelevators");
        handler.addGenerator(MovingElevatorsModelGenerator::new);
        handler.addGenerator(MovingElevatorsAtlasSourceGenerator::new);
        handler.addGenerator(MovingElevatorsBlockStateGenerator::new);
        handler.addGenerator(MovingElevatorsItemInfoGenerator::new);
        handler.addGenerator(MovingElevatorsLanguageGenerator::new);
        handler.addGenerator(MovingElevatorsLootTableGenerator::new);
        handler.addGenerator(MovingElevatorsRecipeGenerator::new);
        handler.addGenerator(MovingElevatorsTagGenerator::new);
    }

    static {
        GROUP = CreativeItemGroup.create((String)"movingelevators", () -> elevator_block.asItem());
        isIrisLoaded = CommonUtils.isModLoaded((String)"iris");
    }
}

