/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.movingelevators.blocks.CamoBlockEntity;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CamoBlock
extends BaseBlock
implements EntityHoldingBlock {
    private static final IntegerProperty OPACITY = IntegerProperty.create((String)"opacity", (int)0, (int)15);
    private final BiFunction<BlockPos, BlockState, ? extends CamoBlockEntity> entitySupplier;

    public CamoBlock(BlockProperties properties, BiFunction<BlockPos, BlockState, ? extends CamoBlockEntity> entitySupplier) {
        super(false, properties.dynamicShape());
        this.entitySupplier = entitySupplier;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)OPACITY, (Comparable)Integer.valueOf(15)));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CamoBlockEntity) {
            this.onRightClick(state, level, (CamoBlockEntity)blockEntity, pos, player, hand, hitSide, hitLocation);
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    protected boolean onRightClick(BlockState state, Level level, CamoBlockEntity blockEntity, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        if (player.isShiftKeyDown() && player.getItemInHand(hand).isEmpty()) {
            blockEntity.setCamoState(null);
            if ((Integer)state.getValue((Property)OPACITY) != 15) {
                level.setBlock(pos, (BlockState)state.setValue((Property)OPACITY, (Comparable)Integer.valueOf(15)), 3);
            }
            return true;
        }
        if (!player.isShiftKeyDown() && blockEntity.canBeCamoStack(player.getItemInHand(hand))) {
            Item item = player.getItemInHand(hand).getItem();
            if (item instanceof BlockItem) {
                Block block = ((BlockItem)item).getBlock();
                BlockState camoState = block.getStateForPlacement(new BlockPlaceContext(new UseOnContext(player, hand, new BlockHitResult(hitLocation, hitSide, pos, false))));
                if (camoState == null) {
                    camoState = block.defaultBlockState();
                }
                blockEntity.setCamoState(camoState);
                int opacity = Math.max(0, Math.min(15, camoState.getLightBlock()));
                if (opacity != (Integer)state.getValue((Property)OPACITY)) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)OPACITY, (Comparable)Integer.valueOf(opacity)), 3);
                }
            }
            return true;
        }
        return false;
    }

    public BlockEntity createNewBlockEntity(BlockPos pos, BlockState state) {
        return (BlockEntity)this.entitySupplier.apply(pos, state);
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = reader.getBlockEntity(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().getVisualShape(reader, pos, context) : BlockShape.fullCube().getUnderlying();
    }

    public int getLightEmission(BlockState state, BlockGetter reader, BlockPos pos) {
        BlockEntity blockEntity = reader.getBlockEntity(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().getLightEmission(reader, pos) : super.getLightEmission(state, reader, pos);
    }

    public float getShadeBrightness(BlockState state, BlockGetter reader, BlockPos pos) {
        BlockEntity blockEntity = reader.getBlockEntity(pos);
        return blockEntity instanceof CamoBlockEntity && ((CamoBlockEntity)blockEntity).hasCamoState() ? ((CamoBlockEntity)blockEntity).getCamoState().getShadeBrightness(reader, pos) : super.getShadeBrightness(state, reader, pos);
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return (Integer)state.getValue((Property)OPACITY) == 0;
    }

    public VoxelShape getOcclusionShape(BlockState state) {
        return BlockShape.empty().getUnderlying();
    }

    public int getLightBlock(BlockState state) {
        return (Integer)state.getValue((Property)OPACITY);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{OPACITY});
    }
}

