/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.DisplayBlockEntity;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class DisplayBlockEntityRenderer
implements CustomBlockEntityRenderer<DisplayBlockEntity, State> {
    private static final double TEXT_RENDER_DISTANCE = 225.0;

    public State createStateHolder() {
        return new State();
    }

    public void updateState(State state, DisplayBlockEntity entity, CustomBlockEntityRenderer.UpdateContext context) {
        int total;
        int height;
        Direction facing;
        if (!entity.isBottomDisplay() || !entity.getInputBlockEntity().hasGroup()) {
            state.shouldRender = false;
            return;
        }
        state.shouldRender = true;
        state.facing = facing = entity.getFacing();
        state.displayHeight = height = entity.hasDisplayOnTop() ? 2 : 1;
        Level level = entity.getLevel();
        BlockPos frontPos = entity.getBlockPos().relative(facing);
        if (height == 1) {
            state.frontLighting = LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)frontPos);
        } else if (level.getBlockState(frontPos).emissiveRendering((BlockGetter)level, frontPos) || level.getBlockState(frontPos.above()).emissiveRendering((BlockGetter)level, frontPos.above())) {
            state.frontLighting = 0xF000F0;
        } else {
            int skyLight = Math.max(level.getBrightness(LightLayer.SKY, frontPos), level.getBrightness(LightLayer.SKY, frontPos.above()));
            int blockLight = Math.max(level.getBrightness(LightLayer.BLOCK, frontPos), level.getBrightness(LightLayer.BLOCK, frontPos.above()));
            int blockStateLight = Math.max(level.getBlockState(frontPos).getLightEmission(), level.getBlockState(frontPos.above()).getLightEmission());
            blockLight = Math.max(blockLight, blockStateLight);
            state.frontLighting = skyLight << 20 | blockLight << 4;
        }
        ModelFeatureRenderer.CrumblingOverlay breakingOverlay = context.breakingOverlay();
        state.combinedOverlay = breakingOverlay == null ? OverlayTexture.NO_OVERLAY : breakingOverlay.progress();
        ElevatorGroup group = entity.getElevatorGroup();
        int index = group.getFloorNumber(entity.getInputBlockEntity().getFloorLevel());
        int button_count = height == 1 ? 3 : 7;
        int below = index;
        int above = group.getFloorCount() - index - 1;
        if (below < above) {
            below = Math.min(below, button_count);
            above = Math.min(above, button_count * 2 - below);
        } else {
            above = Math.min(above, button_count);
            below = Math.min(below, button_count * 2 - above);
        }
        int startIndex = index - below;
        state.floorCount = total = below + 1 + above;
        state.firstFloorIndex = startIndex;
        state.ownFloorIndex = index;
        if (state.floorColors == null || state.floorColors.length < total) {
            state.floorColors = new DyeColor[total];
        }
        if (state.floorNames == null || state.floorNames.length < total) {
            state.floorNames = new String[total];
        }
        Vec3 buttonPos = new Vec3((double)entity.getBlockPos().getX() + 0.5, (double)entity.getBlockPos().getY() + 0.5 * (double)state.displayHeight - (double)((float)state.floorCount * 0.125f) / 2.0, (double)entity.getBlockPos().getZ() + 0.5);
        Vec3 cameraPos = context.cameraPos();
        for (int i = 0; i < total; ++i) {
            int floor = startIndex + i;
            state.floorColors[floor] = group.getFloorDisplayColor(floor);
            state.floorNames[floor] = cameraPos.distanceToSqr(buttonPos) < 225.0 ? MovingElevatorsClient.formatFloorDisplayName(group.getFloorDisplayName(floor), floor) : null;
            buttonPos = buttonPos.add(0.0, 0.125, 0.0);
        }
        double platformY = group.getCurrentY();
        if (group.isMoving() && platformY >= (double)group.getFloorYLevel(0) && platformY < (double)group.getFloorYLevel(group.getFloorCount() - 1)) {
            state.showPlatformDot = true;
            double yOffset = 0.5 * (double)height - (double)((float)total * 0.125f) / 2.0;
            for (int i = 0; i < group.getFloorCount() - 1; ++i) {
                int belowY = group.getFloorYLevel(i);
                int aboveY = group.getFloorYLevel(i + 1);
                if (!(platformY >= (double)belowY) || !(platformY < (double)aboveY)) continue;
                yOffset += ((double)i + (platformY - (double)belowY) / (double)(aboveY - belowY)) * 0.125;
            }
            state.platformDotOffset = yOffset;
        } else {
            state.showPlatformDot = false;
        }
    }

    public void submit(SubmitNodeCollector output, State state, CustomBlockEntityRenderer.RenderContext context) {
        int i;
        if (!state.shouldRender) {
            return;
        }
        Direction facing = state.facing;
        PoseStack poseStack = context.poseStack();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis((double)((180.0f - facing.toYRot()) / 180.0f) * Math.PI, 0.0, 1.0, 0.0));
        poseStack.translate(-0.5, -0.5, -0.51);
        int lighting = state.frontLighting;
        int overlay = state.combinedOverlay;
        if (state.displayHeight == 1) {
            this.drawOverlayPart(poseStack, output, lighting, overlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, 0, 32, 32);
        } else {
            this.drawOverlayPart(poseStack, output, lighting, overlay, facing, 0.0f, 0.0f, 1.0f, 2.0f, 32, 0, 32, 64);
        }
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5 * (double)state.displayHeight - (double)((float)state.floorCount * 0.125f) / 2.0, -0.002);
        poseStack.scale(1.0f, 0.125f, 1.0f);
        for (i = 0; i < state.floorCount; ++i) {
            DyeColor labelColor = state.floorColors[i];
            this.drawOverlayPart(poseStack, output, lighting, overlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, state.firstFloorIndex + i == state.ownFloorIndex ? 96 : 64, labelColor.getId() * 4, 32, 4);
            poseStack.translate(0.0f, 1.0f, 0.0f);
        }
        poseStack.popPose();
        if (state.showPlatformDot) {
            poseStack.pushPose();
            poseStack.translate(0.078125, state.platformDotOffset, -0.003);
            poseStack.scale(0.125f, 0.125f, 1.0f);
            this.drawOverlayPart(poseStack, output, lighting, overlay, facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, 32, 10, 10);
            poseStack.popPose();
        }
        poseStack.pushPose();
        poseStack.translate(0.578125, 0.5 * (double)state.displayHeight - (double)((float)state.floorCount * 0.125f) / 2.0, -0.002);
        poseStack.scale(1.0f, 0.125f, 1.0f);
        for (i = 0; i < state.floorCount; ++i) {
            String floorName = state.floorNames[i];
            if (floorName == null) continue;
            this.drawString(poseStack, output, lighting, floorName);
            poseStack.translate(0.0f, 1.0f, 0.0f);
        }
        poseStack.popPose();
        poseStack.popPose();
    }

    private void drawOverlayPart(PoseStack poseStack, SubmitNodeCollector output, int combinedLight, int combinedOverlay, Direction facing, float x, float y, float width, float height, int tX, int tY, int tWidth, int tHeight) {
        output.submitCustomGeometry(poseStack, Sheets.cutoutBlockSheet(), (pose, buffer) -> {
            Matrix4f matrix = pose.pose();
            TextureAtlasSprite overlaySprite = MovingElevatorsClient.getOverlaySprite();
            float minU = overlaySprite.getU((float)tX / 128.0f);
            float maxU = overlaySprite.getU((float)(tX + tWidth) / 128.0f);
            float minV = overlaySprite.getV((float)tY / 128.0f);
            float maxV = overlaySprite.getV((float)(tY + tHeight) / 128.0f);
            buffer.addVertex(matrix, x, y + height, 0.0f).setColor(255, 255, 255, 255).setUv(maxU, minV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
            buffer.addVertex(matrix, x + width, y + height, 0.0f).setColor(255, 255, 255, 255).setUv(minU, minV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
            buffer.addVertex(matrix, x + width, y, 0.0f).setColor(255, 255, 255, 255).setUv(minU, maxV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
            buffer.addVertex(matrix, x, y, 0.0f).setColor(255, 255, 255, 255).setUv(maxU, maxV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
        });
    }

    private void drawString(PoseStack poseStack, SubmitNodeCollector output, int combinedLight, String s) {
        Font fontRenderer = ClientUtils.getMinecraft().font;
        poseStack.pushPose();
        poseStack.translate(0.0, 0.07, -0.005);
        poseStack.scale(-0.01f, -0.08f, 1.0f);
        float f = (float)(-fontRenderer.width(s)) / 2.0f;
        Objects.requireNonNull(fontRenderer);
        output.submitText(poseStack, f, (float)(-9), FormattedCharSequence.forward((String)s, (Style)Style.EMPTY), false, Font.DisplayMode.NORMAL, combinedLight, -1, 0, 0);
        poseStack.popPose();
    }

    public static class State {
        boolean shouldRender;
        Direction facing;
        int displayHeight;
        int frontLighting;
        int combinedOverlay;
        int floorCount;
        int firstFloorIndex;
        int ownFloorIndex;
        DyeColor[] floorColors;
        String[] floorNames;
        boolean showPlatformDot;
        double platformDotOffset;
    }
}

