/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.render.CustomBlockEntityRenderer;
import com.supermartijn642.movingelevators.MovingElevatorsClient;
import com.supermartijn642.movingelevators.blocks.ControllerBlockEntity;
import com.supermartijn642.movingelevators.blocks.ElevatorInputBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ElevatorInputBlockEntityRenderer<T extends ElevatorInputBlockEntity>
implements CustomBlockEntityRenderer<T, State> {
    public State createStateHolder() {
        return new State();
    }

    public void updateState(State state, T entity, CustomBlockEntityRenderer.UpdateContext context) {
        Direction facing;
        if (((ElevatorInputBlockEntity)((Object)entity)).getFacing() == null || entity instanceof ControllerBlockEntity && !((ControllerBlockEntity)((Object)entity)).shouldShowButtons()) {
            state.shouldRender = false;
            return;
        }
        state.shouldRender = true;
        state.facing = facing = ((ElevatorInputBlockEntity)((Object)entity)).getFacing();
        state.frontLighting = LevelRenderer.getLightColor((BlockAndTintGetter)entity.getLevel(), (BlockPos)entity.getBlockPos().relative(facing));
        state.showCenter = ((ElevatorInputBlockEntity)((Object)entity)).canReceiveInput();
        state.showUp = state.showCenter && ((ElevatorInputBlockEntity)((Object)entity)).canMoveUp();
        state.showDown = state.showCenter && ((ElevatorInputBlockEntity)((Object)entity)).canMoveDown();
    }

    public void submit(SubmitNodeCollector output, State state, CustomBlockEntityRenderer.RenderContext context) {
        if (!state.shouldRender) {
            return;
        }
        PoseStack poseStack = context.poseStack();
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis((double)((180.0f - state.facing.toYRot()) / 180.0f) * Math.PI, 0.0, 1.0, 0.0));
        poseStack.translate(-0.5, -0.5, -0.51);
        ModelFeatureRenderer.CrumblingOverlay breakingOverlay = context.breakingOverlay();
        int overlay = breakingOverlay == null ? OverlayTexture.NO_OVERLAY : breakingOverlay.progress();
        this.drawOverlayPart(poseStack, output, state.frontLighting, overlay, state.facing, 0.0f, 0.0f, 1.0f, 1.0f, 0, state.showUp ? 64 : 87, 23, 23);
        this.drawOverlayPart(poseStack, output, state.frontLighting, overlay, state.facing, 0.0f, 0.0f, 1.0f, 1.0f, 23, state.showCenter ? 64 : 87, 23, 23);
        this.drawOverlayPart(poseStack, output, state.frontLighting, overlay, state.facing, 0.0f, 0.0f, 1.0f, 1.0f, 46, state.showDown ? 64 : 87, 23, 23);
        poseStack.popPose();
    }

    private void drawOverlayPart(PoseStack poseStack, SubmitNodeCollector output, int combinedLight, int combinedOverlay, Direction facing, float x, float y, float width, float height, int tX, int tY, int tWidth, int tHeight) {
        output.submitCustomGeometry(poseStack, Sheets.cutoutBlockSheet(), (pose, buffer) -> {
            Matrix4f matrix = pose.pose();
            TextureAtlasSprite overlaySprite = MovingElevatorsClient.getOverlaySprite();
            float minU = overlaySprite.getU((float)tX / 128.0f);
            float maxU = overlaySprite.getU((float)(tX + tWidth) / 128.0f);
            float minV = overlaySprite.getV((float)tY / 128.0f);
            float maxV = overlaySprite.getV((float)(tY + tHeight) / 128.0f);
            buffer.addVertex(matrix, x, y + height, 0.0f).setColor(255, 255, 255, 255).setUv(maxU, minV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
            buffer.addVertex(matrix, x + width, y + height, 0.0f).setColor(255, 255, 255, 255).setUv(minU, minV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
            buffer.addVertex(matrix, x + width, y, 0.0f).setColor(255, 255, 255, 255).setUv(minU, maxV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
            buffer.addVertex(matrix, x, y, 0.0f).setColor(255, 255, 255, 255).setUv(maxU, maxV).setLight(combinedLight).setNormal(poseStack.last(), (float)facing.getStepX(), (float)facing.getStepY(), (float)facing.getStepZ()).setOverlay(combinedOverlay);
        });
    }

    public static class State {
        boolean shouldRender;
        Direction facing;
        int frontLighting;
        boolean showUp;
        boolean showCenter;
        boolean showDown;
    }
}

