/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.movingelevators.MovingElevators;
import com.supermartijn642.movingelevators.elevator.ElevatorCabinLevel;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.phys.AABB;

public class ClientElevatorCage
extends ElevatorCage {
    private static ElevatorCabinLevel level;
    private BlockPos renderPos = null;
    public final BlockEntity[][][] blockEntities;

    public static Level getFakeLevel() {
        return level;
    }

    public ClientElevatorCage(int xSize, int ySize, int zSize, BlockState[][][] states, CompoundTag[][][] blockEntityData, Tag[][][] blockEntityStacks, List<AABB> collisionBoxes) {
        super(xSize, ySize, zSize, states, blockEntityData, blockEntityStacks, collisionBoxes);
        this.blockEntities = new BlockEntity[xSize][ySize][zSize];
    }

    public void loadRenderInfo(BlockPos renderPos, ElevatorGroup group) {
        if (level == null) {
            level = new ElevatorCabinLevel(ClientUtils.getWorld());
        }
        level.setCabinAndPos(ClientUtils.getWorld(), this, group, renderPos);
        if (renderPos.equals((Object)this.renderPos)) {
            return;
        }
        this.renderPos = renderPos;
        for (int x = 0; x < this.xSize; ++x) {
            for (int y = 0; y < this.ySize; ++y) {
                for (int z = 0; z < this.zSize; ++z) {
                    BlockEntityType entityType;
                    CompoundTag entityData;
                    String identifier;
                    this.blockEntities[x][y][z] = null;
                    if (this.blockStates[x][y][z] == null || this.blockEntityData[x][y][z] == null || (identifier = (entityData = this.blockEntityData[x][y][z]).getStringOr("id", null)) == null || (entityType = (BlockEntityType)Registries.BLOCK_ENTITY_TYPES.getValue(ResourceLocation.parse((String)identifier))) == null) continue;
                    BlockState state = this.blockStates[x][y][z];
                    BlockPos pos = new BlockPos(renderPos.getX() + x, renderPos.getY() + y, renderPos.getZ() + z);
                    BlockEntity entity = entityType.create(pos, state);
                    if (entity == null) continue;
                    try (ProblemReporter.ScopedCollector scopedCollector = new ProblemReporter.ScopedCollector(entity.problemPath(), MovingElevators.LOGGER);){
                        entity.loadWithComponents(TagValueInput.create((ProblemReporter)scopedCollector, (HolderLookup.Provider)group.level.registryAccess(), (CompoundTag)entityData));
                    }
                    entity.setLevel((Level)level);
                    this.blockEntities[x][y][z] = entity;
                }
            }
        }
    }
}

