/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.elevator;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.core.render.RenderWorldEvent;
import com.supermartijn642.movingelevators.elevator.ClientElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorCage;
import com.supermartijn642.movingelevators.elevator.ElevatorGroup;
import com.supermartijn642.movingelevators.elevator.ElevatorGroupCapability;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.components.debug.DebugScreenEntries;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.chunk.ChunkSectionLayerGroup;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.RenderTypeHelper;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Vector3f;

public class ElevatorGroupRenderer {
    private static Vec3 cameraPosition = Vec3.ZERO;
    private static int groupsToRender = 0;
    private static final List<GroupRenderState> groupRenderStates = new ArrayList<GroupRenderState>();

    public static void registerEventListeners() {
        NeoForge.EVENT_BUS.addListener(ElevatorGroupRenderer::onRender);
    }

    private static boolean isWithinRenderDistance(ElevatorGroup group) {
        GameRenderer renderer = ClientUtils.getMinecraft().gameRenderer;
        if (renderer == null) {
            return false;
        }
        float renderDistance = renderer.getRenderDistance() + 8.0f + (float)group.getCageSizeX() / 2.0f + (float)group.getCageSizeZ() / 2.0f;
        BlockPos playerPos = ClientUtils.getPlayer().blockPosition();
        float distance = (group.x - playerPos.getX()) * (group.x - playerPos.getX()) + (group.z - playerPos.getZ()) * (group.z - playerPos.getZ());
        return distance < renderDistance * renderDistance;
    }

    public static void onRender(RenderWorldEvent e) {
        if (!ClientUtils.getMinecraft().debugEntries.isCurrentlyEnabled(DebugScreenEntries.ENTITY_HITBOXES)) {
            return;
        }
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        e.getPoseStack().pushPose();
        Vec3 camera = RenderUtils.getCameraPosition();
        e.getPoseStack().translate(-camera.x, -camera.y, -camera.z);
        for (ElevatorGroup group : groups.getGroups()) {
            if (!ElevatorGroupRenderer.isWithinRenderDistance(group)) continue;
            ElevatorGroupRenderer.renderGroupCageOutlines(e.getPoseStack(), group);
        }
        e.getPoseStack().popPose();
    }

    public static void extractRenderState() {
        cameraPosition = RenderUtils.getCameraPosition();
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        float partialTicks = ClientUtils.getPartialTicks();
        int index = 0;
        for (ElevatorGroup group : groups.getGroups()) {
            if (!group.isMoving() || !ElevatorGroupRenderer.isWithinRenderDistance(group)) continue;
            if (index >= groupRenderStates.size()) {
                groupRenderStates.add(new GroupRenderState());
            }
            ElevatorGroupRenderer.extractGroupRenderState(group, groupRenderStates.get(index), partialTicks);
            ++index;
        }
        groupsToRender = index;
    }

    private static void extractGroupRenderState(ElevatorGroup group, GroupRenderState state, float partialTicks) {
        ClientElevatorCage cage = (ClientElevatorCage)group.getCage();
        double lastY = group.getLastY();
        double currentY = group.getCurrentY();
        double renderY = lastY + (currentY - lastY) * (double)partialTicks;
        Vec3 startPos = group.getCageAnchorPos(renderY);
        BlockPos anchorPos = new BlockPos((int)startPos.x, (int)startPos.y, (int)startPos.z);
        cage.loadRenderInfo(anchorPos, group);
        state.entityCount = 0;
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    if (cage.blockEntities[x][y][z] == null) continue;
                    ++state.entityCount;
                }
            }
        }
        if (state.entityPositions == null || state.entityCount > state.entityPositions.length) {
            if (state.entityPositions == null) {
                state.entityPositions = new Vector3f[state.entityCount];
                state.entityRenderStates = new BlockEntityRenderState[state.entityCount];
            } else {
                state.entityPositions = Arrays.copyOf(state.entityPositions, state.entityCount);
                state.entityRenderStates = Arrays.copyOf(state.entityRenderStates, state.entityCount);
            }
        }
        int index = 0;
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    if (cage.blockEntities[x][y][z] == null) continue;
                    ++state.entityCount;
                    BlockEntity entity = cage.blockEntities[x][y][z];
                    BlockEntityRenderState entityRenderState = ClientUtils.getMinecraft().getBlockEntityRenderDispatcher().tryExtractRenderState(entity, partialTicks, null);
                    if (entityRenderState == null) continue;
                    if (state.entityPositions[index] == null) {
                        state.entityPositions[index] = new Vector3f();
                    }
                    state.entityPositions[index].set(startPos.x + (double)x, startPos.y + (double)y, startPos.z + (double)z);
                    state.entityRenderStates[index] = entityRenderState;
                    ++index;
                }
            }
        }
        state.entityCount = index;
    }

    public static void renderBlocks(PoseStack poseStack, ChunkSectionLayerGroup layers, MultiBufferSource bufferSource) {
        ElevatorGroupCapability groups = ElevatorGroupCapability.get(ClientUtils.getWorld());
        poseStack.pushPose();
        Vec3 camera = RenderUtils.getCameraPosition();
        poseStack.translate(-camera.x, -camera.y, -camera.z);
        EnumSet<ChunkSectionLayer> layersSet = EnumSet.noneOf(ChunkSectionLayer.class);
        layersSet.addAll(Arrays.asList(layers.layers()));
        for (ElevatorGroup group : groups.getGroups()) {
            if (!group.isMoving() || !ElevatorGroupRenderer.isWithinRenderDistance(group)) continue;
            ElevatorGroupRenderer.renderGroupBlocks(poseStack, group, layersSet, bufferSource, ClientUtils.getPartialTicks());
        }
        poseStack.popPose();
    }

    public static void renderBlockEntities(PoseStack poseStack, float partialTicks, CameraRenderState cameraRenderState, SubmitNodeStorage submitNodeStorage) {
        if (groupsToRender == 0) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(-ElevatorGroupRenderer.cameraPosition.x, -ElevatorGroupRenderer.cameraPosition.y, -ElevatorGroupRenderer.cameraPosition.z);
        for (int i = 0; i < groupsToRender; ++i) {
            ElevatorGroupRenderer.renderGroupBlockEntities(poseStack, groupRenderStates.get(i), partialTicks, cameraRenderState, submitNodeStorage);
        }
        poseStack.popPose();
    }

    private static void renderGroupBlocks(PoseStack poseStack, ElevatorGroup group, Set<ChunkSectionLayer> layers, MultiBufferSource bufferSource, float partialTicks) {
        ClientElevatorCage cage = (ClientElevatorCage)group.getCage();
        double lastY = group.getLastY();
        double currentY = group.getCurrentY();
        double renderY = lastY + (currentY - lastY) * (double)partialTicks;
        Vec3 startPos = group.getCageAnchorPos(renderY);
        BlockPos anchorPos = new BlockPos((int)startPos.x, (int)startPos.y, (int)startPos.z);
        cage.loadRenderInfo(anchorPos, group);
        Level level = ClientElevatorCage.getFakeLevel();
        BlockRenderDispatcher blockRenderer = ClientUtils.getBlockRenderer();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = 0; x < group.getCageSizeX(); ++x) {
            for (int y = 0; y < group.getCageSizeY(); ++y) {
                for (int z = 0; z < group.getCageSizeZ(); ++z) {
                    if (cage.blockStates[x][y][z] == null) continue;
                    poseStack.pushPose();
                    poseStack.translate(startPos.x + (double)x, startPos.y + (double)y, startPos.z + (double)z);
                    BlockState state = cage.blockStates[x][y][z];
                    if (state.getRenderShape() == RenderShape.MODEL) {
                        BlockStateModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
                        pos.set(anchorPos.getX() + x, anchorPos.getY() + y, anchorPos.getZ() + z);
                        List parts = model.collectParts((BlockAndTintGetter)level, (BlockPos)pos, state, level.random);
                        blockRenderer.renderBatched(state, (BlockPos)pos, (BlockAndTintGetter)level, poseStack, layer -> bufferSource.getBuffer(RenderTypeHelper.getMovingBlockRenderType((ChunkSectionLayer)layer)), true, parts);
                    }
                    poseStack.popPose();
                }
            }
        }
    }

    private static void renderGroupBlockEntities(PoseStack poseStack, GroupRenderState group, float partialTicks, CameraRenderState cameraRenderState, SubmitNodeStorage submitNodeStorage) {
        if (group.entityCount == 0) {
            return;
        }
        for (int i = 0; i < group.entityCount; ++i) {
            Vector3f position = group.entityPositions[i];
            poseStack.pushPose();
            poseStack.translate(position.x, position.y, position.z);
            BlockEntityRenderState entityRenderState = group.entityRenderStates[i];
            ClientUtils.getMinecraft().getBlockEntityRenderDispatcher().submit(entityRenderState, poseStack, (SubmitNodeCollector)submitNodeStorage, cameraRenderState);
            poseStack.popPose();
        }
    }

    public static void renderGroupCageOutlines(PoseStack poseStack, ElevatorGroup group) {
        for (int floor = 0; floor < group.getFloorCount(); ++floor) {
            BlockPos anchorPos = group.getCageAnchorBlockPos(group.getFloorYLevel(floor));
            AABB cageArea = new AABB((double)anchorPos.getX(), (double)anchorPos.getY(), (double)anchorPos.getZ(), (double)(anchorPos.getX() + group.getCageSizeX()), (double)(anchorPos.getY() + group.getCageSizeY()), (double)(anchorPos.getZ() + group.getCageSizeZ()));
            cageArea.inflate(0.01);
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)cageArea, (float)1.0f, (float)1.0f, (float)1.0f, (boolean)true);
        }
        if (group.isMoving()) {
            ElevatorCage cage = group.getCage();
            double lastY = group.getLastY();
            double currentY = group.getCurrentY();
            double renderY = lastY + (currentY - lastY) * (double)ClientUtils.getPartialTicks();
            Vec3 startPos = group.getCageAnchorPos(renderY);
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)new AABB(startPos, startPos.add((double)group.getCageSizeX(), (double)group.getCageSizeY(), (double)group.getCageSizeZ())), (float)1.0f, (float)0.0f, (float)0.0f, (boolean)true);
            RenderUtils.renderShape((PoseStack)poseStack, (VoxelShape)cage.shape.move(startPos.x, startPos.y, startPos.z), (float)0.19215687f, (float)0.8784314f, (float)0.85882354f, (boolean)true);
        }
    }

    private static class GroupRenderState {
        int entityCount;
        Vector3f[] entityPositions;
        BlockEntityRenderState[] entityRenderStates;

        private GroupRenderState() {
        }
    }
}

