/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui;

import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class SliderWidget
extends BaseWidget {
    public static final ResourceLocation SLIDER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"movingelevators", (String)"gui/slider");
    private final int min;
    private final int max;
    private final int range;
    private int value;
    private int lastValue;
    private final Function<Integer, Component> text;
    private final Consumer<Integer> onChange;
    private boolean dragging = false;
    public boolean active = true;

    public SliderWidget(int x, int y, int width, int min, int max, int startValue, Function<Integer, Component> text, Consumer<Integer> onChange) {
        super(x, y, width, 11);
        if (max < min) {
            throw new IllegalArgumentException("Maximum must be greater than the minimum!");
        }
        if (startValue < min || startValue > max) {
            throw new IllegalArgumentException("Start value must be between the minimum and maximum!");
        }
        this.min = min;
        this.max = max;
        this.range = max - min;
        this.value = this.lastValue = startValue;
        this.text = text;
        this.onChange = onChange;
    }

    public Component getNarrationMessage() {
        return this.text.apply(this.value);
    }

    public void render(WidgetRenderContext context, GuiGraphicsHelper graphics, int mouseX, int mouseY) {
        if (this.dragging) {
            this.value = Math.min(this.max, Math.max(this.min, Math.round((float)(mouseX - this.x) / (float)this.width * (float)this.range) + this.min));
        }
        graphics.submitSprite(SLIDER_TEXTURE, (float)this.x, (float)this.y, 1.0f, (float)this.height, p -> p.uv(0.0f, 0.0f, 0.055555556f, 1.0f));
        graphics.submitSprite(SLIDER_TEXTURE, (float)(this.x + 1), (float)this.y, (float)(this.width - 2), (float)this.height, p -> p.uv(0.055555556f, 0.0f, 0.055555556f, 1.0f));
        graphics.submitSprite(SLIDER_TEXTURE, (float)(this.x + this.width - 1), (float)this.y, 1.0f, (float)this.height, p -> p.uv(0.11111111f, 0.0f, 0.055555556f, 1.0f));
        float percentage = (float)(this.value - this.min) / (float)this.range;
        graphics.submitSprite(SLIDER_TEXTURE, (float)this.x + percentage * (float)(this.width - 5), (float)this.y, 5.0f, (float)this.height, p -> p.uv(this.active ? (this.isFocused() || this.dragging ? 0.44444445f : 0.16666667f) : 0.7222222f, 0.0f, 0.2777778f, 1.0f));
        Component text = this.text.apply(this.value);
        if (text != null) {
            graphics.submitText((FormattedText)text, (float)this.x + (float)this.width / 2.0f, (float)(this.y + 2), p -> p.activeColor().shadow().centerHorizontally());
        }
    }

    public void update() {
        super.update();
        if (this.value != this.lastValue) {
            this.onChange.accept(this.value);
            this.lastValue = this.value;
        }
    }

    public boolean mousePressed(int mouseX, int mouseY, MouseButtonInfo info, boolean isDoubleClick, boolean hasBeenHandled) {
        if (!hasBeenHandled && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            this.dragging = true;
            return true;
        }
        return super.mousePressed(mouseX, mouseY, info, isDoubleClick, hasBeenHandled);
    }

    public boolean mouseReleased(int mouseX, int mouseY, MouseButtonInfo info, boolean hasBeenHandled) {
        if (this.dragging) {
            this.dragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, info, hasBeenHandled);
    }

    public boolean mouseScrolled(int mouseX, int mouseY, double scrollAmount, boolean hasBeenHandled) {
        if (!hasBeenHandled && mouseX >= this.x && mouseX < this.x + this.width && mouseY >= this.y && mouseY < this.y + this.height) {
            if (scrollAmount > 0.0 && this.value < this.max) {
                ++this.value;
            } else if (scrollAmount < 0.0 && this.value > this.min) {
                --this.value;
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollAmount, hasBeenHandled);
    }
}

