/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui.preview;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.movingelevators.gui.preview.WorldBlockCapture;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.FeatureRenderDispatcher;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class ElevatorPreviewRenderer {
    private static final CameraRenderState DUMMY_CAMERA_RENDER_STATE = new CameraRenderState();
    private static FeatureRenderDispatcher featureRenderDispatcher;

    public static void renderPreview(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, WorldBlockCapture.RenderState capture, AABB cabinBox, AABB previewBox, double x, double y, double scale, float yaw, float pitch) {
        AABB bounds = capture.bounds();
        Vec3 center = bounds.getCenter();
        double span = Math.sqrt(bounds.getXsize() * bounds.getXsize() + bounds.getYsize() * bounds.getYsize() + bounds.getZsize() * bounds.getZsize());
        poseStack.translate(x, y, 0.0);
        poseStack.scale((float)(scale /= span), (float)(-scale), (float)(-scale));
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis((double)(pitch / 180.0f) * Math.PI, 1.0, 0.0, 0.0));
        poseStack.mulPose((Quaternionfc)new Quaternionf().setAngleAxis((double)(yaw / 180.0f) * Math.PI, 0.0, 1.0, 0.0));
        poseStack.translate(-center.x, -center.y, -center.z);
        ElevatorPreviewRenderer.setupFeatureRenderer(bufferSource);
        for (int i = 0; i < capture.size(); ++i) {
            ElevatorPreviewRenderer.renderBlock(capture, i, poseStack, (MultiBufferSource)bufferSource);
        }
        featureRenderDispatcher.renderAllFeatures();
        RenderUtils.renderBox((PoseStack)poseStack, (AABB)cabinBox, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f, (boolean)true);
        if (previewBox != null) {
            RenderUtils.renderBox((PoseStack)poseStack, (AABB)previewBox, (float)0.0f, (float)0.7f, (float)0.0f, (float)0.8f, (boolean)true);
        }
    }

    private static void renderBlock(WorldBlockCapture.RenderState capture, int index, PoseStack poseStack, MultiBufferSource bufferSource) {
        BlockEntityRenderState entityRenderState;
        BlockPos pos = capture.position(index);
        poseStack.pushPose();
        poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        BlockState state = capture.state(index);
        if (state.getBlock() != Blocks.AIR) {
            BlockStateModel model = ClientUtils.getBlockRenderer().getBlockModel(state);
            RenderType renderType = ItemBlockRenderTypes.getRenderType((BlockState)state);
            int tint = capture.tint(index);
            ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)bufferSource.getBuffer(renderType), (BlockStateModel)model, (float)ARGB.redFloat((int)tint), (float)ARGB.greenFloat((int)tint), (float)ARGB.blueFloat((int)tint), (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY);
        }
        if ((entityRenderState = capture.entityRenderState(index)) != null) {
            ClientUtils.getMinecraft().getBlockEntityRenderDispatcher().submit(entityRenderState, poseStack, (SubmitNodeCollector)featureRenderDispatcher.getSubmitNodeStorage(), DUMMY_CAMERA_RENDER_STATE);
        }
        poseStack.popPose();
    }

    private static void setupFeatureRenderer(MultiBufferSource.BufferSource bufferSource) {
        if (featureRenderDispatcher == null) {
            featureRenderDispatcher = new FeatureRenderDispatcher(new SubmitNodeStorage(), ClientUtils.getBlockRenderer(), bufferSource, ClientUtils.getMinecraft().getAtlasManager(), new OutlineBufferSource(){

                public VertexConsumer getBuffer(RenderType renderType) {
                    return VertexMultiConsumer.create((VertexConsumer[])new VertexConsumer[0]);
                }
            }, MultiBufferSource.immediate((ByteBufferBuilder)ByteBufferBuilder.exactlySized((int)0)), ClientUtils.getFontRenderer());
        } else {
            ElevatorPreviewRenderer.featureRenderDispatcher.bufferSource = bufferSource;
        }
    }
}

