/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui.preview;

import com.google.common.collect.Maps;
import com.supermartijn642.core.ClientUtils;
import java.util.Map;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class WorldBlockCapture {
    private final Level level;
    private final Map<BlockPos, BlockPos> capturePosToWorldPos = Maps.newHashMap();

    public WorldBlockCapture(Level level) {
        this.level = level;
    }

    public void putBlock(BlockPos capturePos, BlockPos worldPos) {
        this.capturePosToWorldPos.put(capturePos, worldPos);
    }

    public BlockState getBlockState(BlockPos pos) {
        BlockPos worldPos = this.capturePosToWorldPos.get(pos);
        return worldPos == null ? Blocks.AIR.defaultBlockState() : this.level.getBlockState(worldPos);
    }

    public BlockEntity getBlockEntity(BlockPos pos) {
        BlockPos worldPos = this.capturePosToWorldPos.get(pos);
        return worldPos == null ? null : this.level.getBlockEntity(worldPos);
    }

    public Iterable<BlockPos> getBlockLocations() {
        return this.capturePosToWorldPos.keySet();
    }

    public AABB getBounds() {
        if (this.capturePosToWorldPos.isEmpty()) {
            return new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        AABB bounds = new AABB((BlockPos)this.capturePosToWorldPos.keySet().stream().findFirst().get());
        for (BlockPos pos : this.capturePosToWorldPos.keySet()) {
            bounds = bounds.minmax(new AABB(pos));
        }
        return bounds;
    }

    @Deprecated
    public Level getLevel() {
        return this.level;
    }

    public void updateRenderState(RenderState state) {
        state.size = this.capturePosToWorldPos.size();
        if (state.capacity < state.size) {
            state.positions = new BlockPos[state.size];
            state.states = new BlockState[state.size];
            state.tintValues = new int[state.size];
            state.entityStates = new BlockEntityRenderState[state.size];
            state.capacity = state.size;
        }
        int index = 0;
        for (Map.Entry<BlockPos, BlockPos> entry : this.capturePosToWorldPos.entrySet()) {
            BlockEntityRenderer renderer;
            BlockState block;
            state.positions[index] = entry.getKey();
            BlockPos pos = entry.getValue();
            state.states[index] = block = this.level.getBlockState(pos);
            state.tintValues[index] = ClientUtils.getMinecraft().getBlockColors().getColor(block, this.level, pos);
            BlockEntityRenderState entityRenderState = null;
            BlockEntity entity = this.level.getBlockEntity(pos);
            if (entity != null && (renderer = ClientUtils.getMinecraft().getBlockEntityRenderDispatcher().getRenderer(entity)) != null) {
                entityRenderState = renderer.createRenderState();
                renderer.extractRenderState(entity, entityRenderState, ClientUtils.getPartialTicks(), Vec3.ZERO, null);
            }
            state.entityStates[index] = entityRenderState;
            ++index;
        }
        state.bounds = this.getBounds();
    }

    public static class RenderState {
        private int size;
        private int capacity;
        private BlockPos[] positions;
        private AABB bounds;
        private BlockState[] states;
        private int[] tintValues;
        private BlockEntityRenderState[] entityStates;

        public int size() {
            return this.size;
        }

        public BlockPos position(int index) {
            return this.positions[index];
        }

        public AABB bounds() {
            return this.bounds;
        }

        public BlockState state(int index) {
            return this.states[index];
        }

        public int tint(int index) {
            return this.tintValues[index];
        }

        public BlockEntityRenderState entityRenderState(int index) {
            return this.entityStates[index];
        }
    }
}

