/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.model;

import com.supermartijn642.core.ClientUtils;
import java.util.List;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.DynamicBlockStateModel;
import net.neoforged.neoforge.model.data.ModelProperty;
import org.jetbrains.annotations.Nullable;

public class CamoBakedModel
implements DynamicBlockStateModel {
    public static final ModelProperty<BlockState> CAMO_PROPERTY = new ModelProperty();
    private final BlockStateModel originalModel;

    public CamoBakedModel(BlockStateModel originalModel) {
        this.originalModel = originalModel;
    }

    public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        BlockState camouflage = (BlockState)level.getModelData(pos).get(CAMO_PROPERTY);
        if (camouflage == null || camouflage.getBlock() == Blocks.AIR) {
            this.originalModel.collectParts(level, pos, state, random, parts);
            return;
        }
        BlockStateModel model = ClientUtils.getBlockRenderer().getBlockModel(camouflage);
        model.collectParts(level, pos, camouflage, random, parts);
    }

    @Nullable
    public Object createGeometryKey(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random) {
        BlockState camouflage = (BlockState)level.getModelData(pos).get(CAMO_PROPERTY);
        if (camouflage == null || camouflage.getBlock() == Blocks.AIR) {
            return this.originalModel.createGeometryKey(level, pos, state, random);
        }
        BlockStateModel model = ClientUtils.getBlockRenderer().getBlockModel(camouflage);
        return model.createGeometryKey(level, pos, camouflage, random);
    }

    public TextureAtlasSprite particleIcon(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        BlockState camouflage = (BlockState)level.getModelData(pos).get(CAMO_PROPERTY);
        if (camouflage == null || camouflage.getBlock() == Blocks.AIR) {
            return this.originalModel.particleIcon(level, pos, state);
        }
        BlockStateModel model = ClientUtils.getBlockRenderer().getBlockModel(camouflage);
        return model.particleIcon(level, pos, camouflage);
    }

    public TextureAtlasSprite particleIcon() {
        return this.originalModel.particleIcon();
    }
}

