/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.particle.api.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.minecraft.class_11944;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_4184;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class CustomRotationalParticleHelper {
    private static final Vector3f NORMALIZED_QUAT_VECTOR = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
    private float prevXRot;
    private float xRot;
    private float prevYRot;
    private float yRot;
    private float prevRotMultiplier;
    private float rotMultiplier;
    private boolean flipped;

    public void setPrevRotationFromCurrent() {
        this.prevYRot = this.yRot;
        this.prevXRot = this.xRot;
    }

    public void setRotation(float yRot, float xRot) {
        this.yRot = yRot;
        this.xRot = xRot;
        this.setRotMultiplierFromXRot();
    }

    public void setRotationFromMovement(double xd, double yd, double zd, float rotationAmount) {
        double horizontalDistance = Math.sqrt(xd * xd + zd * zd);
        double newYRot = class_3532.method_15349((double)xd, (double)zd) * 57.2957763671875;
        double newXRot = class_3532.method_15349((double)horizontalDistance, (double)yd) * 57.2957763671875;
        double newYRotDifference = class_3532.method_15338((double)(newYRot - (double)this.yRot));
        double newXRotDifference = class_3532.method_15338((double)(newXRot - (double)this.xRot));
        this.yRot += (float)newYRotDifference * rotationAmount;
        this.xRot += (float)newXRotDifference * rotationAmount;
        while (this.yRot - this.prevYRot < -180.0f) {
            this.prevYRot -= 360.0f;
        }
        while (this.yRot - this.prevYRot >= 180.0f) {
            this.prevYRot += 360.0f;
        }
        while (this.xRot - this.prevXRot < -180.0f) {
            this.prevXRot -= 360.0f;
        }
        while (this.xRot - this.prevXRot >= 180.0f) {
            this.prevXRot += 360.0f;
        }
        this.setRotMultiplierFromXRot();
    }

    private void setRotMultiplierFromXRot() {
        this.prevRotMultiplier = this.rotMultiplier;
        this.rotMultiplier = class_3532.method_15374((float)(this.xRot * (float)Math.PI / 180.0f));
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
    }

    private static float[] getUVMapping(float U0, float U1, float V0, float V1, boolean flipped) {
        return new float[]{flipped ? U1 : U0, flipped ? U0 : U1, V0, V1};
    }

    private static Quaternionf createBaseQuaternion() {
        return new Quaternionf().setAngleAxis(0.0f, NORMALIZED_QUAT_VECTOR.x(), NORMALIZED_QUAT_VECTOR.y(), NORMALIZED_QUAT_VECTOR.z());
    }

    public void extract(class_11944 renderState, @NotNull class_4184 camera, class_3940.class_11941 layer, double x, double y, double z, double xd, double yd, double zd, float U0, float U1, float V0, float V1, float quadSize, int color, int lightColor, float partialTicks) {
        float yRot = class_3532.method_16439((float)partialTicks, (float)this.prevYRot, (float)this.yRot) * ((float)Math.PI / 180);
        float xRot = class_3532.method_16439((float)partialTicks, (float)this.prevXRot, (float)this.xRot) * ((float)(-Math.PI) / 180);
        float cameraRotWhileVertical = -camera.method_19330() * (1.0f - class_3532.method_16439((float)partialTicks, (float)this.prevRotMultiplier, (float)this.rotMultiplier)) * ((float)Math.PI / 180);
        float cameraXRot = camera.method_19329();
        class_243 particlePos = new class_243(x, y, z);
        class_243 cameraPos = camera.method_19326();
        double normalizedRelativeY = particlePos.method_1020((class_243)cameraPos).method_1029().method_1020((class_243)new class_243((double)xd, (double)yd, (double)zd).method_1029()).method_1029().field_1351;
        double particleRotation = AdvancedMath.getAngleFromOriginXZ(new class_243(xd, 0.0, zd));
        double angleToParticle = AdvancedMath.getAngleBetweenXZ(particlePos, cameraPos);
        double relativeParticleAngle = (360.0 + (angleToParticle - particleRotation)) % 360.0;
        if (normalizedRelativeY > 0.0) {
            cameraXRot = class_3532.method_16439((float)class_3532.method_27285((float)((float)normalizedRelativeY)), (float)cameraXRot, (float)-90.0f);
        } else if (normalizedRelativeY < 0.0) {
            cameraXRot = class_3532.method_16439((float)class_3532.method_27285((float)((float)Math.abs(normalizedRelativeY))), (float)cameraXRot, (float)90.0f);
        }
        float fixedRotation = 90.0f + cameraXRot;
        if (relativeParticleAngle > 0.0 && relativeParticleAngle < 180.0) {
            fixedRotation *= -1.0f;
        }
        float cameraRotWhileSideways = fixedRotation * class_3532.method_16439((float)partialTicks, (float)this.prevRotMultiplier, (float)this.rotMultiplier) * ((float)Math.PI / 180);
        Quaternionf quatA = CustomRotationalParticleHelper.createBaseQuaternion().rotateY(yRot).rotateX(-xRot).rotateY(cameraRotWhileSideways).rotateY(cameraRotWhileVertical);
        Quaternionf quatB = CustomRotationalParticleHelper.createBaseQuaternion().rotateY((float)(-Math.PI) + yRot).rotateX(xRot).rotateY(cameraRotWhileSideways).rotateY(cameraRotWhileVertical);
        CustomRotationalParticleHelper.submit(renderState, layer, (float)(x - cameraPos.method_10216()), (float)(y - cameraPos.method_10214()), (float)(z - cameraPos.method_10215()), quatA, quatB, quadSize, !this.flipped ? U0 : U1, !this.flipped ? U1 : U0, V0, V1, color, lightColor);
    }

    private static void submit(@NotNull class_11944 renderState, class_3940.class_11941 layer, float x, float y, float z, @NotNull Quaternionf quatA, @NotNull Quaternionf quatB, float quadSize, float uA, float uB, float vA, float vB, int color, int lightColor) {
        renderState.method_74323(layer, x, y, z, quatA.x, quatA.y, quatA.z, quatA.w, quadSize, uA, uB, vA, vB, color, lightColor);
        renderState.method_74323(layer, x, y, z, quatB.x, quatB.y, quatB.z, quatB.w, quadSize, uB, uA, vA, vB, color, lightColor);
    }
}

