/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.compat.serialization.util;

import java.util.BitSet;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.TokenType;

public class StringContext {
    protected final BitSet containers = new BitSet();
    protected boolean expectingKey = false;
    protected boolean top = true;
    protected int level;

    public void prepare(char c) {
        switch (c) {
            case '{': {
                this.push(false);
                break;
            }
            case '[': {
                this.push(true);
                break;
            }
            case ']': 
            case '}': {
                this.pop();
                break;
            }
            case ':': {
                this.expectingKey = false;
            }
        }
    }

    public void update(Token parsed) {
        if (parsed == null) {
            return;
        }
        if (!parsed.isMetadata()) {
            if (parsed.type() != TokenType.SYMBOL && !this.containers.get(this.level)) {
                this.expectingKey = true;
            }
            this.top = false;
        }
    }

    protected void push(boolean isArray) {
        this.containers.set(++this.level, isArray);
        this.expectingKey = !isArray;
    }

    protected void pop() {
        boolean isArray;
        if (this.level == 0) {
            this.expectingKey = true;
            return;
        }
        this.expectingKey = !(isArray = this.containers.get(--this.level));
    }

    public boolean isExpectingKey() {
        return this.expectingKey;
    }

    public boolean isAmbiguous() {
        return this.top;
    }
}

