/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.datafix.api;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1208;
import net.minecraft.class_1220;

public abstract class FrozenEntityRenameFix
extends DataFix {
    private final String name;

    public FrozenEntityRenameFix(Schema outputSchema, String name) {
        super(outputSchema, false);
        this.name = name;
    }

    public TypeRewriteRule makeRule() {
        Type type = DSL.named((String)class_1208.field_5719.typeName(), (Type)class_1220.method_28295());
        if (!Objects.equals(this.getInputSchema().getType(class_1208.field_5719), type)) {
            throw new IllegalStateException("Unexpected entity name type.");
        }
        return this.fixTypeEverywhere(this.name, type, dynamicOps -> pair -> pair.mapSecond(this::fixEntity));
    }

    protected abstract String fixEntity(String var1);

    public static DataFix create(Schema outputSchema, String name, final Function<String, String> function) {
        return new FrozenEntityRenameFix(outputSchema, name){

            @Override
            protected String fixEntity(String string) {
                return (String)function.apply(string);
            }
        };
    }
}

