/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.debug.client.renderer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.core.client.api.FrustumUtil;
import net.frozenblock.lib.debug.client.impl.DebugRenderManager;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_5707;
import net.minecraft.class_5709;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_863;
import net.minecraft.class_9974;
import org.jetbrains.annotations.NotNull;

public class ImprovedGameEventListenerRenderer
implements class_863.class_864 {
    private final class_310 minecraft;
    private final List<TrackedGameEvent> trackedGameEvents = Lists.newArrayList();
    public final List<TrackedListener> trackedListeners = Lists.newArrayList();

    public ImprovedGameEventListenerRenderer(class_310 client) {
        this.minecraft = client;
    }

    public void tick() {
        this.trackedListeners.removeIf(listener -> listener.isExpired((class_1937)this.minecraft.field_1687));
        this.trackedListeners.forEach(trackedListener -> {
            trackedListener.attemptResolveEntity((class_1937)this.minecraft.field_1687);
            trackedListener.attemptResolveBlock((class_1937)this.minecraft.field_1687);
        });
    }

    public void method_23109(class_4587 matrices, class_4597 vertexConsumers, double cameraX, double cameraY, double cameraZ) {
        class_638 level = this.minecraft.field_1687;
        if (level == null) {
            this.trackedGameEvents.clear();
            this.trackedListeners.clear();
        } else {
            class_243 cameraPos = new class_243(cameraX, cameraY, cameraZ);
            ArrayList<TrackedListener> listenersToRender = new ArrayList<TrackedListener>(this.trackedListeners);
            listenersToRender.removeIf(arg_0 -> ImprovedGameEventListenerRenderer.lambda$render$2((class_1937)level, cameraPos, arg_0));
            this.trackedGameEvents.removeIf(TrackedGameEvent::isExpired);
            class_4588 vertexConsumer = vertexConsumers.getBuffer(class_1921.method_23594());
            listenersToRender.removeIf(arg_0 -> ImprovedGameEventListenerRenderer.lambda$render$4((class_1937)level, matrices, vertexConsumer, cameraX, cameraY, cameraZ, arg_0));
            class_4588 vertexConsumer2 = vertexConsumers.getBuffer(class_1921.method_49047());
            for (TrackedListener trackedListener2 : listenersToRender) {
                trackedListener2.getRenderPosition((class_1937)level, DebugRenderManager.PARTIAL_TICK).ifPresent(pos -> class_9974.method_62300((class_4587)matrices, (class_4588)vertexConsumer2, (double)(pos.method_10216() - 0.25 - cameraX), (double)(pos.method_10214() - cameraY), (double)(pos.method_10215() - 0.25 - cameraZ), (double)(pos.method_10216() + 0.25 - cameraX), (double)(pos.method_10214() - cameraY + 1.0), (double)(pos.method_10215() + 0.25 - cameraZ), (float)1.0f, (float)1.0f, (float)0.0f, (float)0.35f));
            }
            for (TrackedListener trackedListener2 : listenersToRender) {
                trackedListener2.getRenderPosition((class_1937)level, DebugRenderManager.PARTIAL_TICK).ifPresent(pos -> {
                    class_863.method_23106((class_4587)matrices, (class_4597)vertexConsumers, (String)"Listener Origin", (double)pos.method_10216(), (double)(pos.method_10214() + (double)1.8f), (double)pos.method_10215(), (int)-1, (float)0.025f);
                    class_863.method_23106((class_4587)matrices, (class_4597)vertexConsumers, (String)class_2338.method_49638((class_2374)pos).toString(), (double)pos.method_10216(), (double)(pos.method_10214() + 1.5), (double)pos.method_10215(), (int)-6959665, (float)0.025f);
                });
            }
            for (TrackedGameEvent trackedGameEvent : this.trackedGameEvents) {
                class_243 vec32 = trackedGameEvent.position;
                double e = vec32.field_1352 - (double)0.2f;
                double f = vec32.field_1351 - (double)0.2f;
                double g = vec32.field_1350 - (double)0.2f;
                double h = vec32.field_1352 + (double)0.2f;
                double i = vec32.field_1351 + (double)0.2f + 0.5;
                double j = vec32.field_1350 + (double)0.2f;
                class_238 renderBox = new class_238(e, f, g, h, i, j);
                if (!FrustumUtil.isVisible(renderBox)) continue;
                ImprovedGameEventListenerRenderer.renderFilledBox(matrices, vertexConsumers, renderBox, 1.0f, 1.0f, 1.0f, 0.2f);
                class_863.method_23106((class_4587)matrices, (class_4597)vertexConsumers, (String)trackedGameEvent.gameEvent.method_29177().toString(), (double)vec32.field_1352, (double)(vec32.field_1351 + (double)0.85f), (double)vec32.field_1350, (int)-7564911, (float)0.0075f);
            }
        }
    }

    private static void renderFilledBox(class_4587 matrices, class_4597 vertexConsumers, class_238 box, float x, float y, float z, float color) {
        class_4184 camera = class_310.method_1551().field_1773.method_19418();
        if (camera.method_19332()) {
            class_243 vec3 = camera.method_19326().method_22882();
            class_863.method_23102((class_4587)matrices, (class_4597)vertexConsumers, (class_238)box.method_997(vec3), (float)x, (float)y, (float)z, (float)color);
        }
    }

    public void trackGameEvent(class_5321<class_5712> registryKey, class_243 pos) {
        this.trackedGameEvents.add(new TrackedGameEvent(class_156.method_658(), registryKey, pos));
    }

    public void trackListener(class_5716 positionSource, int range) {
        this.trackedListeners.add(new TrackedListener(positionSource, range));
    }

    private static /* synthetic */ boolean lambda$render$4(class_1937 level, class_4587 matrices, class_4588 vertexConsumer, double cameraX, double cameraY, double cameraZ, TrackedListener listener) {
        AtomicBoolean willRemove = new AtomicBoolean(true);
        listener.getRenderPosition(level, DebugRenderManager.PARTIAL_TICK).ifPresent(pos -> {
            double l;
            double k;
            double jx;
            double ix;
            double hx;
            double gx = pos.method_10216() - (double)listener.method_32948();
            class_238 aabb = new class_238(gx, hx = pos.method_10214() - (double)listener.method_32948(), ix = pos.method_10215() - (double)listener.method_32948(), jx = pos.method_10216() + (double)listener.method_32948(), k = pos.method_10214() + (double)listener.method_32948(), l = pos.method_10215() + (double)listener.method_32948());
            if (FrustumUtil.isVisible(aabb)) {
                class_863.method_62350((class_4587)matrices, (class_4588)vertexConsumer, (class_265)class_259.method_1078((class_238)aabb), (double)(-cameraX), (double)(-cameraY), (double)(-cameraZ), (float)1.0f, (float)1.0f, (float)0.0f, (float)0.35f, (boolean)true);
                willRemove.set(false);
            }
        });
        return willRemove.get();
    }

    private static /* synthetic */ boolean lambda$render$2(class_1937 level, class_243 cameraPos, TrackedListener listener) {
        return !listener.canRender(level, cameraPos);
    }

    @Environment(value=EnvType.CLIENT)
    static class TrackedListener
    implements class_5714 {
        private class_1297 entity;
        private class_2960 blockId;
        public boolean resolved = false;
        public final class_5716 listenerSource;
        public final int listenerRange;

        public TrackedListener(class_5716 positionSource, int range) {
            this.listenerSource = positionSource;
            this.listenerRange = range;
        }

        public void attemptResolveEntity(class_1937 world) {
            class_5716 class_57162;
            if (!this.resolved && (class_57162 = this.listenerSource) instanceof class_5709) {
                class_5709 entityPositionSource = (class_5709)class_57162;
                entityPositionSource.method_42681(world);
                if (entityPositionSource.field_38424.left().isPresent()) {
                    this.entity = (class_1297)entityPositionSource.field_38424.left().get();
                    this.resolved = true;
                }
            }
        }

        public void attemptResolveBlock(class_1937 world) {
            class_5716 class_57162;
            if (!this.resolved && (class_57162 = this.listenerSource) instanceof class_5707) {
                class_5707 blockPositionSource = (class_5707)class_57162;
                blockPositionSource.method_32956(world).ifPresent(vec3 -> {
                    this.resolved = true;
                    this.blockId = world.method_8320(class_2338.method_49638((class_2374)vec3)).method_26204().method_40142().method_40237().method_29177();
                });
            }
        }

        public boolean canRender(class_1937 world, class_243 pos) {
            return this.listenerSource.method_32956(world).filter(position -> position.method_1025(pos) <= 1024.0).isPresent();
        }

        public boolean isExpired(class_1937 world) {
            if (this.resolved) {
                if (this.listenerSource instanceof class_5709) {
                    return this.entity == null || this.entity.method_31481();
                }
                Optional optional = this.listenerSource.method_32956(world);
                if (optional.isPresent()) {
                    return !world.method_8320(class_2338.method_49638((class_2374)((class_2374)optional.get()))).method_26204().method_40142().method_40226(this.blockId);
                }
            }
            return false;
        }

        public Optional<class_243> getRenderPosition(class_1937 world, float partialTick) {
            class_5716 class_57162;
            if (this.resolved && this.entity != null && (class_57162 = this.listenerSource) instanceof class_5709) {
                class_5709 entityPositionSource = (class_5709)class_57162;
                return Optional.of(this.entity.method_30950(partialTick).method_1031(0.0, (double)entityPositionSource.field_38242, 0.0));
            }
            return this.listenerSource.method_32956(world);
        }

        @NotNull
        public class_5716 method_32946() {
            return this.listenerSource;
        }

        public int method_32948() {
            return this.listenerRange;
        }

        public boolean method_32947(class_3218 world, class_6880<class_5712> gameEvent, class_5712.class_7397 context, class_243 pos) {
            return false;
        }
    }

    @Environment(value=EnvType.CLIENT)
    record TrackedGameEvent(long timeStamp, class_5321<class_5712> gameEvent, class_243 position) {
        public boolean isExpired() {
            return class_156.method_658() - this.timeStamp > 3000L;
        }
    }
}

