/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.cape.impl;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.cape.api.CapeUtil;
import net.frozenblock.lib.cape.impl.Cape;
import net.frozenblock.lib.cape.impl.networking.CapeCustomizePacket;
import net.frozenblock.lib.cape.impl.networking.LoadCapeRepoPacket;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ServerCapeData {
    private static final Map<UUID, Cape> CAPES_IN_SERVER = new HashMap<UUID, Cape>();

    public static void sendAllCapesToPlayer(class_3222 recipient) {
        CAPES_IN_SERVER.forEach((uuid, cape) -> ServerPlayNetworking.send((class_3222)recipient, (class_8710)CapeCustomizePacket.createPacket(uuid, cape)));
    }

    public static void sendCapeReposToPlayer(class_3222 recipient) {
        CapeUtil.getCapeRepos().forEach(repoURL -> ServerPlayNetworking.send((class_3222)recipient, (class_8710)new LoadCapeRepoPacket((String)repoURL)));
    }

    public static void init() {
        ServerLifecycleEvents.SERVER_STOPPING.register(client -> CAPES_IN_SERVER.clear());
        ServerPlayConnectionEvents.DISCONNECT.register((serverGamePacketListener, minecraftServer) -> {
            UUID uuid = serverGamePacketListener.method_32311().method_5667();
            if (CAPES_IN_SERVER.remove(uuid) != null) {
                for (class_3222 serverPlayer : PlayerLookup.all((MinecraftServer)minecraftServer)) {
                    ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)CapeCustomizePacket.createDisablePacket(uuid));
                }
            }
        });
        CapeUtil.registerCape(FrozenLibConstants.id("dummy"), null, (class_2561)class_2561.method_43471((String)"cape.frozenlib.dummy"));
        ImmutableList devs = ImmutableList.of((Object)UUID.fromString("097b76e8-ac32-410f-b81c-38dd4086b97c"), (Object)UUID.fromString("e4d5386a-2255-450b-9478-17ed2a31041d"), (Object)UUID.fromString("62af0c47-6817-45be-8147-6adc2c9681c3"), (Object)UUID.fromString("ccaa0664-8fd4-4176-96b4-eab6f8c75083"), (Object)UUID.fromString("659b74f7-b151-426a-b9c4-a71cd2fb64c6"), (Object)UUID.fromString("6e9aaed3-c6e5-43f4-9151-d0cdaa51cb6d"));
        ImmutableList artists = ImmutableList.of((Object)UUID.fromString("321a6c75-182f-4de0-b660-6b48e6853f7a"), (Object)UUID.fromString("7e6a4565-4f83-40a7-8fc1-ca14547b9fcd"), (Object)UUID.fromString("a851a138-cf93-4b1e-b94b-9361a7343f00"));
        ImmutableList builders = ImmutableList.of((Object)UUID.fromString("b7d99111-f8b8-4627-a7a7-1ef3d58708f5"), (Object)UUID.fromString("2d12cab0-7338-44ed-96de-b6da49c7f07c"), (Object)UUID.fromString("b93722c4-28a1-4e1a-956c-0c04f46db116"));
        ImmutableList composers = ImmutableList.of((Object)UUID.fromString("321a6c75-182f-4de0-b660-6b48e6853f7a"), (Object)UUID.fromString("ce9dd341-b1c2-44d9-a014-71e11d163b01"));
        ImmutableList soundDesigners = ImmutableList.of((Object)UUID.fromString("097b76e8-ac32-410f-b81c-38dd4086b97c"));
        ImmutableList contributors = ImmutableList.of((Object)UUID.fromString("12c8d9b4-1416-4e4f-8696-de2faf9f76b0"), (Object)UUID.fromString("6b9f0883-3611-4a57-adb4-2da330283887"), (Object)UUID.fromString("3f89b045-9f47-49ac-b9a0-be2c225bd7fa"), (Object)UUID.fromString("3300ab83-ec59-4846-b8dd-058b6e0dab37"), (Object)UUID.fromString("53ff8a64-6996-4c1c-92ea-b2cb01f5a5fc"));
        ImmutableList translators = ImmutableList.of((Object)UUID.fromString("f7ab161c-7370-4ec2-9bf5-8f5d37eb91f6"), (Object)UUID.fromString("3f89b045-9f47-49ac-b9a0-be2c225bd7fa"));
        CapeUtil.registerCapesFromURL("https://raw.githubusercontent.com/FrozenBlock/CapeRepo/refs/heads/master/cape_directory.json");
    }
}

