/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.FrozenLibLogUtils;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.registry.ConfigRegistry;
import net.frozenblock.lib.config.impl.network.ConfigSyncModification;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public record ConfigModification<T>(Consumer<T> modification) {
    public static <T> T modifyConfig(Config<T> config, T original, boolean excludeNonSync) {
        try {
            T instance = config.configClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            ConfigModification.copyInto(original, instance);
            List list = ConfigRegistry.getModificationsForConfig(config).entrySet().stream().sorted(Map.Entry.comparingByValue()).toList();
            config.setSynced(false);
            for (Map.Entry modification : list) {
                Consumer<T> consumer = ((ConfigModification)modification.getKey()).modification;
                if (!(consumer instanceof ConfigSyncModification) && excludeNonSync) continue;
                ((ConfigModification)modification.getKey()).modification.accept(instance);
            }
            return instance;
        }
        catch (Exception e) {
            FrozenLibLogUtils.logError("Failed to modify config, returning original.", true, e);
            return original;
        }
    }

    public static <T> void copyInto(@NotNull T source, T destination, boolean isSyncModification) {
        Class<?> clazz = source.getClass();
        while (!clazz.equals(Object.class)) {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                if (isSyncModification && !ConfigSyncModification.isSyncable(field)) continue;
                try {
                    field.set(destination, field.get(source));
                }
                catch (IllegalAccessException e) {
                    FrozenLibLogUtils.logError("Failed to copy field " + field.getName(), true, e);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    public static <T> void copyInto(@NotNull T source, T destination) {
        ConfigModification.copyInto(source, destination, false);
    }

    @Environment(value=EnvType.CLIENT)
    public static enum EntryPermissionType {
        CAN_MODIFY(true, Optional.empty(), Optional.empty()),
        LOCKED_FOR_UNKNOWN_REASON(false, Optional.of(class_2561.method_43471((String)"tooltip.frozenlib.locked_due_to_unknown_reason")), Optional.of(class_2561.method_43471((String)"tooltip.frozenlib.locked_due_to_unknown_reason"))),
        LOCKED_DUE_TO_SERVER(false, Optional.of(class_2561.method_43471((String)"tooltip.frozenlib.locked_due_to_server")), Optional.of(class_2561.method_43471((String)"tooltip.frozenlib.locked_due_to_server_lan"))),
        LOCKED_DUE_TO_SYNC(false, Optional.of(class_2561.method_43471((String)"tooltip.frozenlib.locked_due_to_sync")), Optional.of(class_2561.method_43471((String)"tooltip.frozenlib.locked_due_to_sync_lan")));

        public final boolean canModify;
        public final Optional<class_2561> tooltip;
        public final Optional<class_2561> lanTooltip;

        private EntryPermissionType(boolean canModify, Optional<class_2561> tooltip, Optional<class_2561> lanTooltip) {
            this.canModify = canModify;
            this.tooltip = tooltip;
            this.lanTooltip = lanTooltip;
        }
    }
}

