/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.item.api.removable;

import java.util.LinkedHashMap;
import java.util.Set;
import net.frozenblock.lib.FrozenLibLogUtils;
import net.frozenblock.lib.item.api.removable.RemovalPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RemovableDataComponents {
    private static final LinkedHashMap<class_6880<class_9331<?>>, RemovableDataComponent> REMOVABLE_DATA_COMPONENTS = new LinkedHashMap();

    public static void register(class_9331<?> component, RemovalPredicate removalPredicate, boolean removeOnStackMerge) {
        class_5321 key = (class_5321)class_7923.field_49658.method_29113(component).orElseThrow();
        class_6880.class_6883 holder = class_7923.field_49658.method_46747(key);
        REMOVABLE_DATA_COMPONENTS.put((class_6880<class_9331<?>>)holder, new RemovableDataComponent((class_6880<class_9331<?>>)holder, removalPredicate, removeOnStackMerge));
    }

    public static boolean canRemoveComponent(class_9331<?> component, class_1937 level, class_1297 entity, class_1304 equipmentSlot) {
        class_5321 key = (class_5321)class_7923.field_49658.method_29113(component).orElseThrow();
        class_6880.class_6883 holder = class_7923.field_49658.method_46747(key);
        RemovableDataComponent removableDataComponent = REMOVABLE_DATA_COMPONENTS.get(holder);
        if (removableDataComponent != null) {
            return removableDataComponent.shouldRemove(level, entity, equipmentSlot);
        }
        FrozenLibLogUtils.logError("Unable to find RemovableDataComponent for DataComponent " + String.valueOf(key.method_29177()) + "!", true, null);
        FrozenLibLogUtils.logError("Please make sure " + String.valueOf(key.method_29177()) + " is registered in RemovableDataComponents.class!", true, null);
        return false;
    }

    public static boolean shouldRemoveComponentOnStackMerge(class_9331<?> component) {
        class_5321 key = (class_5321)class_7923.field_49658.method_29113(component).orElseThrow();
        class_6880.class_6883 holder = class_7923.field_49658.method_46747(key);
        RemovableDataComponent removableDataComponent = REMOVABLE_DATA_COMPONENTS.get(holder);
        if (removableDataComponent != null) {
            return removableDataComponent.shouldRemoveOnStackMerge();
        }
        FrozenLibLogUtils.logError("Unable to find RemovableDataComponent data for DataComponent " + String.valueOf(key.method_29177()) + "!", true, null);
        FrozenLibLogUtils.logError("Please make sure " + String.valueOf(key.method_29177()) + " is registered in RemovableDataComponents.class!", true, null);
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static Set<class_6880<class_9331<?>>> keys() {
        return REMOVABLE_DATA_COMPONENTS.keySet();
    }

    public static class RemovableDataComponent
    implements RemovalPredicate {
        private final class_6880<class_9331<?>> component;
        private final RemovalPredicate predicate;
        private final boolean removeOnStackMerge;

        public RemovableDataComponent(class_6880<class_9331<?>> component, RemovalPredicate predicate, boolean removeOnStackMerge) {
            this.component = component;
            this.predicate = predicate;
            this.removeOnStackMerge = removeOnStackMerge;
        }

        public class_6880<class_9331<?>> getComponent() {
            return this.component;
        }

        @Override
        public boolean shouldRemove(class_1937 level, class_1297 entity, class_1304 equipmentSlot) {
            return this.predicate.shouldRemove(level, entity, equipmentSlot);
        }

        public boolean shouldRemoveOnStackMerge() {
            return this.removeOnStackMerge;
        }
    }
}

