/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.particle.client;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.particle.api.client.CustomRotationalParticleHelper;
import net.frozenblock.lib.particle.options.WindParticleOptions;
import net.frozenblock.lib.tag.api.FrozenBlockTags;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.minecraft.class_11944;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_5329;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class WindParticle
extends class_3940 {
    protected final CustomRotationalParticleHelper rotationalHelper = new CustomRotationalParticleHelper();
    private final class_4002 spriteSet;
    private final double windMovementScale;
    private final float rotationChangeAmount;
    protected int ageBeforeDissipating;
    private boolean shouldDissipate;
    private boolean chosenSide;

    WindParticle(@NotNull class_638 level, @NotNull class_4002 spriteSet, @NotNull WindParticleOptions.ParticleLength particleLength, double x, double y, double z, double xd, double yd, double zd) {
        super(level, x, y, z, xd, yd, zd, spriteSet.method_74304());
        this.field_17867 *= 3.0f * particleLength.getQuadSizeScale();
        this.method_3080(0.3f, 0.3f);
        this.spriteSet = spriteSet;
        this.windMovementScale = particleLength.getWindMovementScale();
        this.rotationChangeAmount = particleLength.getRotationChangeAmount();
        this.field_3847 = 19;
        this.field_3862 = false;
        this.field_28786 = 0.95f;
        this.field_3844 = 0.0f;
        this.rotationalHelper.setFlipped(level.field_9229.method_43056());
    }

    public void method_3070() {
        super.method_3070();
        this.rotationalHelper.setPrevRotationFromCurrent();
        if (!this.shouldDissipate) {
            double multXZ = 0.007;
            double multY = 0.0010425;
            class_243 pos = new class_243(this.field_3874, this.field_3854, this.field_3871);
            class_243 wind = ClientWindManager.getWindMovement((class_1937)this.field_3851, pos, this.windMovementScale, 7.0, 5.0);
            this.field_3852 += wind.method_10216() * multXZ;
            this.field_3869 += wind.method_10214() * multY;
            this.field_3850 += wind.method_10215() * multXZ;
            this.setRotationFromMovement(this.rotationChangeAmount);
        } else {
            this.field_28786 = 0.2f;
        }
        if (this.shouldDissipate && this.field_3866 > 7 && this.field_3866 < this.ageBeforeDissipating) {
            this.field_3866 = this.ageBeforeDissipating;
        }
        if (this.field_3866 >= this.ageBeforeDissipating && !this.chosenSide) {
            this.chosenSide = true;
            this.rotationalHelper.setFlipped(this.field_3851.field_9229.method_43056());
            this.field_3847 = this.ageBeforeDissipating + 11;
        }
        this.method_74306(this.spriteSet);
    }

    public void setRotationFromMovement(float rotationAmount) {
        this.rotationalHelper.setRotationFromMovement(this.field_3852, this.field_3869, this.field_3850, rotationAmount);
    }

    public void method_3069(double x, double y, double z) {
        boolean canDissipate;
        class_243 vec3;
        if (this.shouldDissipate) {
            return;
        }
        double d = x;
        double e = y;
        double f = z;
        if ((x != 0.0 || y != 0.0 || z != 0.0) && x * x + y * y + z * z < class_3532.method_33723((double)100.0)) {
            vec3 = this.collideBoundingBox(new class_243(x, y, z));
            x = vec3.field_1352;
            y = vec3.field_1351;
            z = vec3.field_1350;
        }
        vec3 = new class_243(d, e, f);
        boolean bl = canDissipate = this.field_3866 > 7;
        if (canDissipate && vec3.method_1033() < 0.0065) {
            this.shouldDissipate = true;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.method_3067(this.method_3064().method_989(x, y, z));
            this.method_3072();
        } else if (canDissipate) {
            this.shouldDissipate = true;
        }
        if (Math.abs(e) >= (double)1.0E-5f && Math.abs(y) < (double)1.0E-5f) {
            this.shouldDissipate = true;
        }
        boolean bl2 = this.field_3845 = e != y && e < 0.0;
        if (d != x) {
            this.field_3852 = 0.0;
            this.shouldDissipate = true;
        }
        if (f != z) {
            this.field_3850 = 0.0;
            this.shouldDissipate = true;
        }
    }

    @NotNull
    private class_243 collideBoundingBox(class_243 vec3) {
        class_238 box = this.method_3064();
        ImmutableList shapes = ImmutableList.copyOf(this.getBlockCollisions(box.method_18804(vec3)));
        return class_1297.method_20737((class_243)vec3, (class_238)box, (List)shapes);
    }

    @Contract(pure=true)
    @NotNull
    private Iterable<class_265> getBlockCollisions(class_238 box) {
        return () -> new class_5329((class_1941)this.field_3851, class_3726.method_16194(), box, false, (pos, shape) -> {
            if (this.field_3851.method_8320((class_2338)pos).method_26164(FrozenBlockTags.BLOWING_CAN_PASS_THROUGH)) {
                return class_259.method_1073();
            }
            return shape;
        });
    }

    public void method_74306(@NotNull class_4002 spriteSet) {
        if (this.field_3843) {
            return;
        }
        int frame = this.field_3866 < 8 ? this.field_3866 : (this.field_3866 < this.ageBeforeDissipating ? 8 : this.field_3866 - this.ageBeforeDissipating + 9);
        this.method_74307(spriteSet.method_18138(Math.min(frame, 20), 20));
    }

    public void method_3074(@NotNull class_11944 renderState, @NotNull class_4184 camera, float partialTicks) {
        this.rotationalHelper.extract(renderState, camera, this.method_74255(), class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874), class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854), class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871), this.field_3852, this.field_3869, this.field_3850, this.method_18133(), this.method_18134(), this.method_18135(), this.method_18136(), this.method_18132(partialTicks), class_9848.method_61318((float)this.field_62636, (float)this.field_62633, (float)this.field_62634, (float)this.field_62635), this.method_3068(partialTicks), partialTicks);
    }

    @NotNull
    protected class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62641;
    }

    @Environment(value=EnvType.CLIENT)
    public record Factory(@NotNull class_4002 spriteProvider) implements class_707<WindParticleOptions>
    {
        @NotNull
        public class_703 createParticle(@NotNull WindParticleOptions options, @NotNull class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @NotNull class_5819 random) {
            class_243 velocity = options.getVelocity();
            WindParticle windParticle = new WindParticle(level, this.spriteProvider, options.length(), x, y, z, 0.0, 0.0, 0.0);
            windParticle.ageBeforeDissipating = options.getLifespan();
            windParticle.field_3847 += windParticle.ageBeforeDissipating;
            windParticle.field_3852 = velocity.field_1352;
            windParticle.field_3850 = velocity.field_1350;
            windParticle.field_3869 = velocity.field_1351;
            windParticle.setRotationFromMovement(1.0f);
            windParticle.rotationalHelper.setPrevRotationFromCurrent();
            return windParticle;
        }
    }
}

