/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.screenshake.api.client;

import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class ScreenShaker {
    public static final ArrayList<ClientScreenShake> SCREEN_SHAKES = new ArrayList();
    private static float prevYRot;
    private static float yRot;
    private static float prevXRot;
    private static float xRot;
    private static float prevZRot;
    private static float zRot;

    @ApiStatus.Internal
    public static void tick(@NotNull class_638 level) {
        if (level.method_54719().method_54751()) {
            class_310 client = class_310.method_1551();
            prevYRot = yRot;
            prevXRot = xRot;
            prevZRot = zRot;
            if (!client.method_31321() && client.method_1493()) {
                yRot = 0.0f;
                xRot = 0.0f;
                zRot = 0.0f;
                return;
            }
            class_1041 window = client.method_22683();
            int windowWidth = window.method_4489();
            int windowHeight = window.method_4506();
            class_5819 randomSource = level.method_8409();
            SCREEN_SHAKES.removeIf(clientScreenShake -> clientScreenShake.shouldRemove((class_1937)level));
            float highestIntensity = 0.0f;
            float totalIntensity = 0.0f;
            int amount = 0;
            for (ClientScreenShake screenShake : SCREEN_SHAKES) {
                screenShake.tick();
                float shakeIntensity = screenShake.getIntensity(client.field_1773.method_19418().method_19326());
                if (shakeIntensity > 0.0f) {
                    totalIntensity += shakeIntensity;
                    highestIntensity = Math.max(shakeIntensity, highestIntensity);
                    ++amount;
                }
                ++screenShake.ticks;
            }
            float intensity = amount > 0 && totalIntensity != 0.0f && highestIntensity != 0.0f ? highestIntensity + totalIntensity / (float)amount * 0.5f : 0.0f;
            yRot += (class_3532.method_15344((class_5819)randomSource, (float)(-intensity), (float)intensity) * ((float)windowWidth / (float)windowHeight) - yRot) * 0.65f;
            xRot += (class_3532.method_15344((class_5819)randomSource, (float)(-intensity), (float)intensity) - xRot) * 0.65f;
            zRot += (class_3532.method_15344((class_5819)randomSource, (float)(-intensity), (float)intensity) - zRot) * 0.65f;
        }
    }

    @ApiStatus.Internal
    public static void reset() {
        prevXRot = 0.0f;
        prevYRot = 0.0f;
        prevZRot = 0.0f;
        xRot = 0.0f;
        yRot = 0.0f;
        zRot = 0.0f;
        ScreenShaker.clear();
    }

    @ApiStatus.Internal
    public static void shake(@NotNull class_4587 poseStack, float partialTicks) {
        poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(class_3532.method_16439((float)partialTicks, (float)prevYRot, (float)yRot)));
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)partialTicks, (float)prevXRot, (float)xRot)));
        poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(class_3532.method_16439((float)partialTicks, (float)prevZRot, (float)zRot)));
    }

    public static void addShake(class_638 level, float intensity, int duration, int falloffStart, class_243 pos, float maxDistance, int ticks) {
        SCREEN_SHAKES.add(new ClientScreenShake((class_1937)level, intensity, duration, falloffStart, pos, maxDistance, ticks));
    }

    public static void addShake(class_1297 entity, float intensity, int duration, int falloffStart, float maxDistance, int ticks) {
        SCREEN_SHAKES.add(new ClientEntityScreenShake(entity, intensity, duration, falloffStart, maxDistance, ticks));
    }

    @ApiStatus.Internal
    public static void clear() {
        SCREEN_SHAKES.clear();
    }

    public static class ClientScreenShake {
        public final int duration;
        public final float maxDistance;
        private final float intensity;
        private final int durationFalloffStart;
        public class_1937 level;
        public int ticks;
        protected class_243 pos;

        public ClientScreenShake(class_1937 level, float intensity, int duration, int durationFalloffStart, class_243 pos, float maxDistance, int ticks) {
            this.level = level;
            this.intensity = intensity;
            this.duration = duration;
            this.durationFalloffStart = durationFalloffStart;
            this.pos = pos;
            this.maxDistance = maxDistance;
            this.ticks = ticks;
        }

        public float getIntensity(@NotNull class_243 playerPos) {
            float distanceBasedIntensity = Math.max((float)(1.0 - playerPos.method_1022(this.pos) / (double)this.maxDistance), 0.0f);
            if (distanceBasedIntensity > 0.0f) {
                float timeFromFalloffStart = Math.max(this.ticks - this.durationFalloffStart, 0);
                float falloffTime = this.duration - this.durationFalloffStart;
                float lerpedTimeFromFalloffStart = class_3532.method_16439((float)((float)this.ticks / (float)this.duration), (float)0.0f, (float)timeFromFalloffStart);
                return distanceBasedIntensity * ((falloffTime - lerpedTimeFromFalloffStart) / falloffTime) * this.intensity;
            }
            return 0.0f;
        }

        public void tick() {
        }

        public boolean shouldRemove(class_1937 level) {
            return this.ticks > this.duration || level != this.level;
        }
    }

    public static class ClientEntityScreenShake
    extends ClientScreenShake {
        private final class_1297 entity;

        public ClientEntityScreenShake(@NotNull class_1297 entity, float intensity, int duration, int durationFalloffStart, float maxDistance, int ticks) {
            super(entity.method_73183(), intensity, duration, durationFalloffStart, entity.method_73189(), maxDistance, ticks);
            this.entity = entity;
        }

        @Override
        public float getIntensity(@NotNull class_243 playerPos) {
            if (this.entity != null && !this.entity.method_31481()) {
                this.pos = this.entity.method_73189();
                return super.getIntensity(playerPos);
            }
            return 0.0f;
        }

        public class_1297 getEntity() {
            return this.entity;
        }

        @Override
        public void tick() {
            super.tick();
            this.level = this.entity.method_73183();
        }

        @Override
        public boolean shouldRemove(class_1937 level) {
            return super.shouldRemove(level) || this.entity == null || this.entity.method_31481();
        }
    }
}

