/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.compat.serialization.token;

import java.io.IOException;
import net.frozenblock.lib.shadow.xjs.data.StringType;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Token;
import net.frozenblock.lib.shadow.xjs.data.serialization.token.Tokenizer;
import net.frozenblock.lib.shadow.xjs.data.serialization.util.PositionTrackingReader;
import org.jetbrains.annotations.Nullable;

public class JsoncTokenizer
extends Tokenizer {
    public JsoncTokenizer(PositionTrackingReader reader, boolean containerized) {
        super(reader, containerized);
    }

    @Override
    @Nullable
    protected Token single() throws IOException {
        this.reader.skipLineWhitespace();
        if (this.reader.isEndOfText()) {
            return null;
        }
        char c = (char)this.reader.current;
        this.startReading();
        return switch (c) {
            case '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9' -> this.number();
            case '#', '/' -> this.comment(c);
            case '\"' -> this.newStringToken(this.reader.readQuoted('\"'), StringType.DOUBLE);
            case '\n' -> this.newLine();
            case 't' -> this.readTrue();
            case 'f' -> this.readFalse();
            case 'n' -> this.readNull();
            case ',', ':', '[', ']', '{', '}' -> this.readSymbol();
            default -> throw this.reader.unexpected();
        };
    }

    private Token readTrue() throws IOException {
        PositionTrackingReader reader = this.reader;
        reader.read();
        reader.expect('r');
        reader.expect('u');
        reader.expect('e');
        return this.newWordToken("true");
    }

    private Token readFalse() throws IOException {
        PositionTrackingReader reader = this.reader;
        reader.read();
        reader.expect('a');
        reader.expect('l');
        reader.expect('s');
        reader.expect('e');
        return this.newWordToken("false");
    }

    private Token readNull() throws IOException {
        PositionTrackingReader reader = this.reader;
        reader.read();
        reader.expect('u');
        reader.expect('l');
        reader.expect('l');
        return this.newWordToken("null");
    }

    private Token readSymbol() throws IOException {
        PositionTrackingReader reader = this.reader;
        char c = (char)reader.current;
        reader.read();
        return this.newSymbolToken(c);
    }
}

