/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.sound.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.frozenblock.lib.sound.api.predicate.SoundPredicate;
import net.frozenblock.lib.sound.impl.networking.FrozenLibSoundPackets;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class MovingLoopingFadingDistanceSoundEntityManager {
    private final ArrayList<FadingDistanceSoundLoopNBT> sounds = new ArrayList();
    public final class_1297 entity;

    public MovingLoopingFadingDistanceSoundEntityManager(class_1297 entity) {
        this.entity = entity;
    }

    public void load(@NotNull class_11368 input) {
        this.sounds.clear();
        class_11368.class_11369 list = input.method_71437("frozenlib_looping_fading_distance_sounds", FadingDistanceSoundLoopNBT.CODEC);
        for (FadingDistanceSoundLoopNBT sound : list) {
            this.sounds.add(sound);
        }
    }

    public void save(class_11372 nbt) {
        if (!this.sounds.isEmpty()) {
            class_11372.class_11373 list = nbt.method_71467("frozenlib_looping_fading_distance_sounds", FadingDistanceSoundLoopNBT.CODEC);
            for (FadingDistanceSoundLoopNBT sound : this.sounds) {
                list.method_71484((Object)sound);
            }
        }
    }

    public void addSound(class_2960 soundID, class_2960 soundID2, class_3419 category, float volume, float pitch, class_2960 restrictionId, boolean stopOnDeath, float fadeDist, float maxDist) {
        this.sounds.add(new FadingDistanceSoundLoopNBT(soundID, soundID2, category, volume, pitch, fadeDist, maxDist, restrictionId, stopOnDeath));
        SoundPredicate.getPredicate(restrictionId).onStart(this.entity);
    }

    public ArrayList<FadingDistanceSoundLoopNBT> getSounds() {
        return this.sounds;
    }

    public void tick() {
        if (!this.sounds.isEmpty()) {
            ArrayList<FadingDistanceSoundLoopNBT> soundsToRemove = new ArrayList<FadingDistanceSoundLoopNBT>();
            for (FadingDistanceSoundLoopNBT nbt : this.sounds) {
                SoundPredicate.LoopPredicate<class_1297> predicate = SoundPredicate.getPredicate(nbt.restrictionID);
                if (predicate.test(this.entity)) continue;
                soundsToRemove.add(nbt);
                predicate.onStop(this.entity);
            }
            this.sounds.removeAll(soundsToRemove);
        }
    }

    public void syncWithPlayer(class_3222 serverPlayer) {
        for (FadingDistanceSoundLoopNBT nbt : this.getSounds()) {
            FrozenLibSoundPackets.createAndSendMovingRestrictionLoopingFadingDistanceSound(serverPlayer, this.entity, (class_6880<class_3414>)((class_6880)class_7923.field_41172.method_10223(nbt.soundEventID()).orElseThrow()), (class_6880<class_3414>)((class_6880)class_7923.field_41172.method_10223(nbt.soundEventID2()).orElseThrow()), (class_3419)class_3419.valueOf(class_3419.class, (String)nbt.category), nbt.volume, nbt.pitch, nbt.restrictionID, nbt.stopOnDeath, nbt.fadeDist, nbt.maxDist);
        }
    }

    public record FadingDistanceSoundLoopNBT(class_2960 soundEventID, class_2960 soundEventID2, String category, float volume, float pitch, float fadeDist, float maxDist, class_2960 restrictionID, boolean stopOnDeath) {
        public static final Codec<FadingDistanceSoundLoopNBT> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("soundEventID").forGetter(FadingDistanceSoundLoopNBT::soundEventID), (App)class_2960.field_25139.fieldOf("sound2EventID").forGetter(FadingDistanceSoundLoopNBT::soundEventID2), (App)Codec.STRING.fieldOf("categoryOrdinal").forGetter(FadingDistanceSoundLoopNBT::category), (App)Codec.FLOAT.fieldOf("volume").forGetter(FadingDistanceSoundLoopNBT::volume), (App)Codec.FLOAT.fieldOf("pitch").forGetter(FadingDistanceSoundLoopNBT::pitch), (App)Codec.FLOAT.fieldOf("fadeDist").forGetter(FadingDistanceSoundLoopNBT::fadeDist), (App)Codec.FLOAT.fieldOf("maxDist").forGetter(FadingDistanceSoundLoopNBT::maxDist), (App)class_2960.field_25139.fieldOf("restrictionID").forGetter(FadingDistanceSoundLoopNBT::restrictionID), (App)Codec.BOOL.fieldOf("stopOnDeath").forGetter(FadingDistanceSoundLoopNBT::stopOnDeath)).apply((Applicative)instance, FadingDistanceSoundLoopNBT::new));

        public FadingDistanceSoundLoopNBT(class_2960 soundEventID, class_2960 soundEventID2, @NotNull class_3419 category, float volume, float pitch, float fadeDist, float maxDist, class_2960 restrictionID, boolean stopOnDeath) {
            this(soundEventID, soundEventID2, category.toString(), volume, pitch, fadeDist, maxDist, restrictionID, stopOnDeath);
        }
    }
}

