/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.core.registry.api.event;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.qsl.frozenblock.core.registry.api.event.RegistryMonitor;

@ApiStatus.NonExtendable
public interface DynamicRegistryManagerSetupContext {
    @Contract(pure=true)
    @NotNull
    public class_5455 registryManager();

    @NotNull
    default public <V> Optional<V> register(@NotNull class_5321<? extends class_2378<V>> registryKey, @NotNull class_2960 id, @NotNull Supplier<V> gameObjectSupplier) {
        return this.registryManager().method_46759(registryKey).map(registry -> registry.method_10250(id) ? registry.method_63535(id) : class_2378.method_10230((class_2378)registry, (class_2960)id, gameObjectSupplier.get()));
    }

    @Contract(pure=true)
    @Nullable
    default public RegistryMap getRegistries(@NotNull Set<class_5321<? extends class_2378<?>>> registryKeys) {
        if (registryKeys.isEmpty()) {
            throw new IllegalArgumentException("Please provide at least one registry to gather.");
        }
        Map foundRegistries = null;
        for (class_5321<class_2378<?>> class_53212 : registryKeys) {
            Optional maybe = this.registryManager().method_46759(class_53212);
            if (!maybe.isPresent()) continue;
            if (foundRegistries == null) {
                foundRegistries = new Reference2ObjectOpenHashMap();
            }
            foundRegistries.put(class_53212, (class_2378)maybe.get());
        }
        if (foundRegistries == null || foundRegistries.size() != registryKeys.size()) {
            return null;
        }
        return new RegistryMap(foundRegistries);
    }

    default public void withRegistries(@NotNull Consumer<RegistryMap> action, @NotNull Set<class_5321<? extends class_2378<?>>> registryKeys) {
        RegistryMap registries = this.getRegistries(registryKeys);
        if (registries != null) {
            action.accept(registries);
        }
    }

    default public <V> void monitor(class_5321<? extends class_2378<V>> registryKey, Consumer<RegistryMonitor<V>> action) {
        this.registryManager().method_46759(registryKey).ifPresent(registry -> action.accept(RegistryMonitor.create(registry)));
    }

    public record RegistryMap(Map<class_5321<? extends class_2378<?>>, class_2378<?>> registries) {
        @Contract(pure=true)
        public <V> class_2378<V> get(class_5321<? extends class_2378<V>> registryKey) {
            return this.registries.get(registryKey);
        }

        @NotNull
        public <V> V register(@NotNull class_5321<? extends class_2378<V>> registryKey, @NotNull class_2960 id, @NotNull V gameObject) {
            return (V)class_2378.method_10230(this.get(registryKey), (class_2960)id, gameObject);
        }
    }
}

