/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.cape.client.api;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.cape.api.CapeUtil;
import net.frozenblock.lib.cape.impl.Cape;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1068;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@Environment(value=EnvType.CLIENT)
public class ClientCapeUtil {
    public static final Path CAPE_CACHE_PATH = FrozenLibConstants.FROZENLIB_GAME_DIRECTORY.resolve("cape_cache");
    private static final List<class_2960> REGISTERED_CAPE_LISTENERS = new ArrayList<class_2960>();
    private static final List<Cape> USABLE_CAPES = new ArrayList<Cape>();

    public static void registerCapeTextureFromURL(final @NotNull class_2960 capeLocation, final class_2960 capeTextureLocation, final String textureURL) throws JsonIOException {
        if (!REGISTERED_CAPE_LISTENERS.contains(capeLocation)) {
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

                public class_2960 getFabricId() {
                    return capeLocation;
                }

                public void method_14491(@NotNull class_3300 resourceManager) {
                    CompletableFuture completableFuture = new CompletableFuture();
                    class_1046 httpTexture = new class_1046(CAPE_CACHE_PATH.resolve(capeLocation.method_12836()).resolve(capeLocation.method_12832() + ".png").toFile(), textureURL, class_1068.method_4649(), false, () -> completableFuture.complete(capeTextureLocation));
                    class_310.method_1551().method_1531().method_4616(capeTextureLocation, (class_1044)httpTexture);
                }
            });
            REGISTERED_CAPE_LISTENERS.add(capeLocation);
        }
    }

    public static void refreshUsableCapes() {
        USABLE_CAPES.clear();
        UUID playerUUID = class_310.method_1551().method_1548().method_44717();
        USABLE_CAPES.addAll(CapeUtil.getUsableCapes(playerUUID));
    }

    @NotNull
    public static @Unmodifiable List<Cape> getUsableCapes(boolean refresh) {
        if (refresh) {
            ClientCapeUtil.refreshUsableCapes();
        }
        return ImmutableList.copyOf(USABLE_CAPES);
    }

    public static boolean hasUsableCapes(boolean refresh) {
        if (refresh) {
            ClientCapeUtil.refreshUsableCapes();
        }
        return USABLE_CAPES.size() > 1;
    }
}

