/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.debug.client.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.frozenblock.lib.debug.client.api.DebugRendererEvents;
import net.frozenblock.lib.debug.client.impl.DebugRendererHolder;
import net.frozenblock.lib.debug.client.renderer.ImprovedGameEventListenerRenderer;
import net.frozenblock.lib.debug.client.renderer.ImprovedGoalSelectorDebugRenderer;
import net.frozenblock.lib.debug.client.renderer.WindDebugRenderer;
import net.frozenblock.lib.debug.client.renderer.WindDisturbanceDebugRenderer;
import net.frozenblock.lib.debug.networking.GoalDebugRemovePayload;
import net.frozenblock.lib.debug.networking.ImprovedGameEventDebugPayload;
import net.frozenblock.lib.debug.networking.ImprovedGameEventListenerDebugPayload;
import net.frozenblock.lib.debug.networking.ImprovedGoalDebugPayload;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.frozenblock.lib.wind.impl.networking.WindAccessPacket;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class DebugRenderManager {
    public static Map<DebugRendererHolder, class_2960> DEBUG_RENDERER_HOLDERS = new Object2ObjectLinkedOpenHashMap();
    private static final List<Runnable> ON_CLEAR_RUNNABLES = new ArrayList<Runnable>();
    public static float PARTIAL_TICK;

    public static void registerRenderer(class_2960 location, DebugRendererHolder.RenderInterface renderInterface) {
        if (location == null) {
            throw new IllegalArgumentException("ResourceLocation cannot be null!");
        }
        DEBUG_RENDERER_HOLDERS.put(new DebugRendererHolder(renderInterface), location);
        Stream<Map.Entry> entries = DEBUG_RENDERER_HOLDERS.entrySet().stream().sorted(Comparator.comparing(value -> ((class_2960)value.getValue()).method_12832()));
        Object2ObjectLinkedOpenHashMap newRenderHolders = new Object2ObjectLinkedOpenHashMap();
        entries.forEach(arg_0 -> DebugRenderManager.lambda$registerRenderer$1((Map)newRenderHolders, arg_0));
        DEBUG_RENDERER_HOLDERS = newRenderHolders;
    }

    public static void init() {
        DebugRendererEvents.DEBUG_RENDERERS_CREATED.register(client -> {
            ImprovedGoalSelectorDebugRenderer improvedGoalSelectorRenderer = new ImprovedGoalSelectorDebugRenderer(client);
            ClientPlayNetworking.registerGlobalReceiver(ImprovedGoalDebugPayload.PACKET_TYPE, (packet, ctx) -> {
                class_1297 entity = ctx.client().field_1687.method_8469(packet.entityId());
                if (entity != null) {
                    improvedGoalSelectorRenderer.addGoalSelector(entity, packet.goals());
                }
            });
            ClientPlayNetworking.registerGlobalReceiver(GoalDebugRemovePayload.PACKET_TYPE, (packet, ctx) -> improvedGoalSelectorRenderer.removeGoalSelector(packet.entityId()));
            DebugRenderManager.addClearRunnable(improvedGoalSelectorRenderer::method_20414);
            DebugRenderManager.registerRenderer(FrozenLibConstants.id("goal"), improvedGoalSelectorRenderer::method_23109);
        });
        DebugRendererEvents.DEBUG_RENDERERS_CREATED.register(client -> {
            ImprovedGameEventListenerRenderer improvedGameEventRenderer = new ImprovedGameEventListenerRenderer(client);
            ClientPlayNetworking.registerGlobalReceiver(ImprovedGameEventListenerDebugPayload.PACKET_TYPE, (packet, ctx) -> improvedGameEventRenderer.trackListener(packet.listenerPos(), packet.listenerRange()));
            ClientPlayNetworking.registerGlobalReceiver(ImprovedGameEventDebugPayload.PACKET_TYPE, (packet, ctx) -> improvedGameEventRenderer.trackGameEvent(packet.gameEventType(), packet.pos()));
            ClientTickEvents.START_WORLD_TICK.register(clientLevel -> {
                if (FrozenLibConfig.IS_DEBUG) {
                    improvedGameEventRenderer.tick();
                }
            });
            DebugRenderManager.registerRenderer(FrozenLibConstants.id("game_event"), improvedGameEventRenderer::method_23109);
        });
        DebugRendererEvents.DEBUG_RENDERERS_CREATED.register(client -> {
            WindDebugRenderer windDebugRenderer = new WindDebugRenderer(client);
            ClientTickEvents.START_WORLD_TICK.register(clientLevel -> {
                if (FrozenLibConfig.IS_DEBUG) {
                    windDebugRenderer.tick();
                    ClientWindManager.clearAccessedPositions();
                }
            });
            ClientPlayNetworking.registerGlobalReceiver(WindAccessPacket.PACKET_TYPE, (packet, ctx) -> ClientWindManager.addAccessedPosition(packet.accessPos()));
            DebugRenderManager.addClearRunnable(windDebugRenderer::method_20414);
            DebugRenderManager.registerRenderer(FrozenLibConstants.id("wind"), windDebugRenderer::method_23109);
        });
        DebugRendererEvents.DEBUG_RENDERERS_CREATED.register(client -> {
            WindDisturbanceDebugRenderer windDisturbanceDebugRenderer = new WindDisturbanceDebugRenderer(client);
            ClientTickEvents.START_WORLD_TICK.register(clientLevel -> {
                if (FrozenLibConfig.IS_DEBUG) {
                    windDisturbanceDebugRenderer.tick();
                }
            });
            DebugRenderManager.addClearRunnable(windDisturbanceDebugRenderer::method_20414);
            DebugRenderManager.registerRenderer(FrozenLibConstants.id("wind_disturbance"), windDisturbanceDebugRenderer::method_23109);
        });
    }

    public static void clearAdditionalRenderers() {
        ON_CLEAR_RUNNABLES.forEach(Runnable::run);
    }

    public static void addClearRunnable(Runnable runnable) {
        ON_CLEAR_RUNNABLES.add(runnable);
    }

    public static void updatePartialTick() {
        PARTIAL_TICK = class_310.method_1551().method_60646().method_60637(true);
    }

    private static /* synthetic */ void lambda$registerRenderer$1(Map newRenderHolders, Map.Entry entry) {
        newRenderHolders.put((DebugRendererHolder)entry.getKey(), (class_2960)entry.getValue());
    }
}

