/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.file.transfer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.config.frozenlib_config.FrozenLibConfig;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public record FileTransferPacket(String transferPath, String fileName, boolean request, FileTransferSnippet snippet, int totalPacketCount) implements class_8710
{
    @ApiStatus.Internal
    public static final class_8710.class_9154<FileTransferPacket> PACKET_TYPE = new class_8710.class_9154(FrozenLibConstants.id("file_transfer"));
    @ApiStatus.Internal
    public static final class_9139<class_2540, FileTransferPacket> STREAM_CODEC = class_9139.method_56438(FileTransferPacket::write, FileTransferPacket::create);
    private static final int MAX_BYTES_PER_TRANSFER = 0x1C0000;

    @ApiStatus.Internal
    @NotNull
    public static FileTransferPacket create(@NotNull class_2540 buf) {
        return new FileTransferPacket(buf.method_19772(), buf.method_19772(), buf.readBoolean(), FileTransferSnippet.read(buf), buf.method_10816());
    }

    @NotNull
    public static @Unmodifiable List<FileTransferPacket> create(String destPath, @NotNull File file) throws IOException {
        Pair<Integer, List<FileTransferSnippet>> snippets = FileTransferPacket.createSnippets(FileTransferPacket.readFile(file));
        int totalPacketCount = (Integer)snippets.getFirst();
        ArrayList<FileTransferPacket> packets = new ArrayList<FileTransferPacket>();
        for (FileTransferSnippet snippet : (List)snippets.getSecond()) {
            packets.add(new FileTransferPacket(destPath, file.getName(), false, snippet, totalPacketCount));
        }
        return ImmutableList.copyOf(packets);
    }

    @NotNull
    public static FileTransferPacket createRequest(String requestPath, String fileName) {
        return new FileTransferPacket(requestPath, fileName, true, FileTransferSnippet.EMPTY, 0);
    }

    @ApiStatus.Internal
    private static byte @Nullable [] readFile(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            fileInputStream.transferTo(byteArrayOutputStream);
            fileInputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendToPlayer(File file, String destPath, class_3222 player) throws IOException {
        if (!FrozenLibConfig.FILE_TRANSFER_SERVER) {
            return;
        }
        for (FileTransferPacket packet : FileTransferPacket.create(destPath, file)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        }
    }

    @ApiStatus.Internal
    private void write(@NotNull class_2540 buf) {
        buf.method_10814(this.transferPath);
        buf.method_10814(this.fileName);
        buf.method_52964(this.request);
        this.snippet.write(buf);
        buf.method_10804(this.totalPacketCount);
    }

    @ApiStatus.Internal
    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_TYPE;
    }

    @NotNull
    private static Pair<Integer, List<FileTransferSnippet>> createSnippets(byte[] bytes) {
        AtomicInteger index = new AtomicInteger(0);
        ArrayList snippets = new ArrayList();
        Lists.partition(Arrays.asList(ArrayUtils.toObject((byte[])bytes)), (int)0x1C0000).forEach(byteChunk -> snippets.add(new FileTransferSnippet(ArrayUtils.toPrimitive((Byte[])byteChunk.toArray(new Byte[0])), index.incrementAndGet())));
        return Pair.of((Object)index.get(), snippets);
    }

    public record FileTransferSnippet(byte[] bytes, int index) {
        public static final FileTransferSnippet EMPTY = new FileTransferSnippet(new byte[0], 0);

        @Contract(value="_ -> new")
        @NotNull
        public static FileTransferSnippet read(@NotNull class_2540 byteBuf) {
            return new FileTransferSnippet(byteBuf.method_10795(), byteBuf.method_10816());
        }

        @Contract(value="_ -> param1")
        @NotNull
        public ByteBuf write(@NotNull class_2540 byteBuf) {
            byteBuf.method_10813(this.bytes);
            byteBuf.method_10804(this.index);
            return byteBuf;
        }
    }
}

