/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.shadow.xjs.data;

import net.frozenblock.lib.shadow.xjs.data.JsonType;
import net.frozenblock.lib.shadow.xjs.data.JsonValue;
import net.frozenblock.lib.shadow.xjs.data.StringType;

public class JsonString
extends JsonValue {
    private final String value;
    private StringType type;

    public JsonString(String value) {
        this(value, StringType.NONE);
    }

    public JsonString(String value, StringType type) {
        this.value = value;
        this.type = type;
    }

    public StringType getStringType() {
        return this.type;
    }

    public JsonString setStringType(StringType type) {
        this.type = type;
        return this;
    }

    @Override
    public JsonString setDefaultMetadata(JsonValue other) {
        if (other instanceof JsonString) {
            JsonString s = (JsonString)other;
            if (this.type == StringType.NONE) {
                this.type = s.type;
            }
        }
        return (JsonString)super.setDefaultMetadata(other);
    }

    @Override
    public JsonType getType() {
        return JsonType.STRING;
    }

    @Override
    public String unwrap() {
        return this.value;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public double intoDouble() {
        return this.value.length();
    }

    @Override
    public JsonString copy(int options) {
        JsonString copy = new JsonString(this.value);
        if ((options & 8) == 8) {
            copy.type = this.type;
        }
        return JsonString.withMetadata(copy, this, options);
    }

    @Override
    protected boolean matchesMetadata(JsonValue other) {
        if (other instanceof JsonString) {
            return this.type.equals((Object)((JsonString)other).type) && super.matchesMetadata(other);
        }
        return false;
    }
}

