/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.biome.api.parameters;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.frozenblock.lib.worldgen.biome.api.parameters.OverworldBiomeBuilderParameters;
import net.minecraft.class_6544;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class FrozenBiomeParameters {
    public static void addWeirdness(BiomeRunnable runnable, @NotNull List<class_6544.class_6546> weirdnesses) {
        for (class_6544.class_6546 weirdness : weirdnesses) {
            runnable.run(weirdness);
        }
    }

    @NotNull
    public static class_6544.class_6546 inBetween(class_6544.class_6546 par1, class_6544.class_6546 par2, float width) {
        float highest;
        if (width >= 1.0f || width <= 0.0f) {
            throw new IllegalArgumentException("FrozenLib: Cannot run inBetween if width >= 1 or width <= 0!");
        }
        width *= 0.5f;
        float lowest = par1.comp_103();
        if (lowest > (highest = (float)par2.comp_104())) {
            throw new IllegalArgumentException("FrozenLib: Cannot run inBetween when lower parameter is higher than the first!");
        }
        float difference = highest - lowest;
        float middle = lowest + difference * 0.5f;
        float offset = difference * width;
        return class_6544.class_6546.method_38121((float)(middle - offset), (float)(middle + offset));
    }

    @NotNull
    public static class_6544.class_6546 inBetweenLowCutoff(class_6544.class_6546 par1, class_6544.class_6546 par2, float width) {
        float highest;
        if (width >= 1.0f || width <= 0.0f) {
            throw new IllegalArgumentException("FrozenLib: Cannot run inBetweenLowCutoff if width >= 1 or width <= 0!");
        }
        width *= 0.5f;
        float lowest = par1.comp_103();
        if (lowest > (highest = (float)par2.comp_104())) {
            throw new IllegalArgumentException("FrozenLib: Cannot run inBetweenLowCutoff when lower parameter is higher than the first!");
        }
        float difference = highest - lowest;
        float middle = lowest + difference * 0.5f;
        float offset = difference * width;
        return class_6544.class_6546.method_38121((float)lowest, (float)(middle - offset));
    }

    @NotNull
    public static class_6544.class_6546 inBetweenHighCutoff(class_6544.class_6546 par1, class_6544.class_6546 par2, float width) {
        float highest;
        if (width >= 1.0f || width <= 0.0f) {
            throw new IllegalArgumentException("FrozenLib: Cannot run inBetweenHighCutoff if width >= 1 or width <= 0!");
        }
        width *= 0.5f;
        float lowest = par1.comp_103();
        if (lowest > (highest = (float)par2.comp_104())) {
            throw new IllegalArgumentException("FrozenLib: Cannot run inBetweenHighCutoff when lower parameter is higher than the first!");
        }
        float difference = highest - lowest;
        float middle = lowest + difference * 0.5f;
        float offset = difference * width;
        return class_6544.class_6546.method_38121((float)(middle + offset), (float)highest);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_6546 makeParameterBorder(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_6546 firstParameter, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_6546 secondParameter, float percentagePerSlot) {
        long secondMin;
        long border = firstParameter.comp_104();
        if (border != (secondMin = secondParameter.comp_103())) {
            throw new IllegalArgumentException("FrozenLib: Cannot run makeParameterBorder when firstParameter's max is not equal to secondParameter's min!");
        }
        long firstWidth = firstParameter.comp_104() - firstParameter.comp_103();
        long secondWidth = secondParameter.comp_104() - secondParameter.comp_103();
        return new class_6544.class_6546((long)((float)border - (float)firstWidth * percentagePerSlot), (long)((float)border + (float)secondWidth * percentagePerSlot));
    }

    @NotNull
    public static List<class_6544.class_4762> findBorderParameters(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_4762 point1, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_4762 point2, float percentagePerSlot) {
        List<class_6544.class_6546> erosions;
        List<class_6544.class_6546> continentalnesses;
        List<class_6544.class_6546> humidities;
        ArrayList<class_6544.class_4762> borders = new ArrayList<class_6544.class_4762>();
        List<class_6544.class_6546> temperatures = FrozenBiomeParameters.findBorderParameters(point1.comp_105(), point2.comp_105(), percentagePerSlot);
        if (!(temperatures.isEmpty() || (humidities = FrozenBiomeParameters.findBorderParameters(point1.comp_106(), point2.comp_106(), percentagePerSlot)).isEmpty() || (continentalnesses = FrozenBiomeParameters.findBorderParameters(point1.comp_107(), point2.comp_107(), percentagePerSlot)).isEmpty() || (erosions = FrozenBiomeParameters.findBorderParameters(point1.comp_108(), point2.comp_108(), percentagePerSlot)).isEmpty())) {
            long offset = (long)((double)(point1.comp_111() + point2.comp_111()) * 0.5);
            temperatures.forEach(temperature -> humidities.forEach(humidity -> continentalnesses.forEach(continentalness -> erosions.forEach(erosion -> borders.add(new class_6544.class_4762(temperature, humidity, continentalness, erosion, OverworldBiomeBuilderParameters.FULL_RANGE, OverworldBiomeBuilderParameters.FULL_RANGE, offset))))));
        }
        return borders;
    }

    @NotNull
    public static List<class_6544.class_4762> findBorderParameters(@NotNull List<class_6544.class_4762> pointList1, @NotNull List<class_6544.class_4762> pointList2, float percentagePerSlot) {
        ArrayList<class_6544.class_4762> borders = new ArrayList<class_6544.class_4762>();
        pointList1.forEach(point1 -> pointList2.forEach(point2 -> borders.addAll(FrozenBiomeParameters.findBorderParameters(point1, point2, percentagePerSlot))));
        return borders;
    }

    @NotNull
    public static List<class_6544.class_6546> findBorderParameters(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_6546 firstParameter, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_6546 secondParameter, float percentagePerSlot) {
        ArrayList<class_6544.class_6546> borders = new ArrayList<class_6544.class_6546>();
        if (firstParameter.equals((Object)secondParameter)) {
            return List.of(firstParameter);
        }
        List<class_6544.class_6546> splitFirstParam = FrozenBiomeParameters.splitParameter(firstParameter, secondParameter);
        List<class_6544.class_6546> splitSecondParam = FrozenBiomeParameters.splitParameter(secondParameter, firstParameter);
        splitFirstParam.forEach(parameter1 -> splitSecondParam.forEach(parameter2 -> {
            if (parameter1.equals(parameter2) && !borders.contains(parameter1)) {
                borders.add((class_6544.class_6546)parameter1);
            } else {
                class_6544.class_6546 borderParameter2;
                try {
                    borderParameter2 = FrozenBiomeParameters.makeParameterBorder(parameter1, parameter2, percentagePerSlot);
                    if (!borders.contains(borderParameter2)) {
                        borders.add(borderParameter2);
                    }
                }
                catch (IllegalArgumentException borderParameter2) {
                    // empty catch block
                }
                try {
                    borderParameter2 = FrozenBiomeParameters.makeParameterBorder(parameter2, parameter1, percentagePerSlot);
                    if (!borders.contains(borderParameter2)) {
                        borders.add(borderParameter2);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }));
        return borders;
    }

    @Contract(pure=true)
    @NotNull
    public static List<class_6544.class_6546> splitParameter(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_6546 parameter, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_6544.class_6546 referenceParameter) {
        ArrayList<class_6544.class_6546> splitParameters = new ArrayList<class_6544.class_6546>();
        long min = parameter.comp_103();
        long max = parameter.comp_104();
        long refMin = referenceParameter.comp_103();
        long refMax = referenceParameter.comp_104();
        if (min < refMin) {
            splitParameters.add(new class_6544.class_6546(min, refMin));
        }
        if (max > refMax) {
            splitParameters.add(new class_6544.class_6546(refMax, max));
        }
        if (min <= refMin && max >= refMax) {
            splitParameters.add(new class_6544.class_6546(refMin, refMax));
        }
        return splitParameters;
    }

    @NotNull
    @Contract(value="_, _ -> new")
    public static class_6544.class_6546 squish(@NotNull class_6544.class_6546 parameter, float squish) {
        return class_6544.class_6546.method_38121((float)((float)parameter.comp_103() + squish), (float)((float)parameter.comp_104() - squish));
    }

    public static boolean isWeird(@NotNull class_6544.class_4762 point) {
        return point.comp_110().comp_104() < 0L;
    }

    @Generated
    private FrozenBiomeParameters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface BiomeRunnable {
        public void run(class_6544.class_6546 var1);
    }
}

