/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.worldgen.structure.impl.status;

import java.util.ArrayList;
import java.util.List;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.worldgen.structure.impl.StructureStartInterface;
import net.frozenblock.lib.worldgen.structure.impl.status.PlayerStructureStatus;
import net.frozenblock.lib.worldgen.structure.impl.status.PlayerStructureStatusInterface;
import net.frozenblock.lib.worldgen.structure.impl.status.networking.PlayerStructureStatusPacket;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3449;
import net.minecraft.class_5138;
import net.minecraft.class_8710;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class StructureStatusUpdater {
    @ApiStatus.Internal
    public static void updatePlayerStructureStatusesForLevel(@NotNull class_3218 level) {
        class_5138 structureManager = level.method_27056();
        level.method_18456().forEach(player -> StructureStatusUpdater.updatePlayerStructureStatus(structureManager, player));
    }

    @ApiStatus.Internal
    private static void updatePlayerStructureStatus(@NotNull class_5138 structureManager, @NotNull class_3222 player) {
        if (player instanceof PlayerStructureStatusInterface) {
            PlayerStructureStatusInterface structureStatusInterface = (PlayerStructureStatusInterface)player;
            class_2338 pos = player.method_24515();
            ArrayList<PlayerStructureStatus> newStructureStatuses = new ArrayList<PlayerStructureStatus>();
            List<PlayerStructureStatus> currentStructureStatuses = structureStatusInterface.frozenLib$getStructureStatuses();
            for (class_3195 structure : structureManager.method_41037(pos).keySet()) {
                class_3449 class_34492;
                class_3449 structureStart = structureManager.method_28388(pos, structure);
                if (structureStart == class_3449.field_16713 || !((class_34492 = structureStart) instanceof StructureStartInterface)) continue;
                StructureStartInterface structureStartInterface = (StructureStartInterface)class_34492;
                class_2960 structureLocation = structureStartInterface.frozenLib$getId();
                if (structureLocation != null) {
                    boolean insidePiece = structureManager.method_41033(pos, structureStart);
                    boolean addNewStructureStatus = true;
                    for (PlayerStructureStatus existingStatus : newStructureStatuses) {
                        if (!existingStatus.getStructure().equals((Object)structureLocation)) continue;
                        addNewStructureStatus = false;
                        if (existingStatus.isInsidePiece() || !insidePiece) continue;
                        existingStatus.setInsidePiece(true);
                    }
                    if (!addNewStructureStatus) continue;
                    newStructureStatuses.add(new PlayerStructureStatus(structureLocation, insidePiece));
                    continue;
                }
                if (FrozenLibConstants.UNSTABLE_LOGGING) {
                    throw new AssertionError((Object)"Structure piece doesn't contain an id!");
                }
            }
            if (!newStructureStatuses.equals(currentStructureStatuses)) {
                structureStatusInterface.frozenLib$setStructureStatuses(newStructureStatuses);
                StructureStatusUpdater.sendStructureStatusPacket(player, newStructureStatuses);
            }
        }
    }

    @ApiStatus.Internal
    private static void sendStructureStatusPacket(@NotNull class_3222 player, @NotNull List<PlayerStructureStatus> structureStatuses) {
        player.field_13987.method_14364((class_2596)new class_2658((class_8710)new PlayerStructureStatusPacket(structureStatuses)));
    }
}

