/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.toml;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import net.frozenblock.lib.config.api.instance.Config;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class TomlConfig<T>
extends Config<T> {
    public static final String EXTENSION = "toml";
    private final TomlWriter tomlWriter;

    public TomlConfig(String modId, Class<T> config) {
        this(modId, config, new TomlWriter.Builder());
    }

    public TomlConfig(String modId, Class<T> config, TomlWriter.Builder builder) {
        this(modId, config, TomlConfig.makePath(modId, EXTENSION), builder);
    }

    public TomlConfig(String modId, Class<T> config, Path path, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TomlWriter.Builder builder) {
        super(modId, config, path, true);
        this.tomlWriter = builder.build();
        if (this.load()) {
            this.save();
        }
    }

    @Override
    public void onSave() throws Exception {
        Files.createDirectories(this.path().getParent(), new FileAttribute[0]);
        BufferedWriter writer = Files.newBufferedWriter(this.path(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        this.tomlWriter.write(this.instance(), (Writer)writer);
        writer.close();
    }

    @Override
    public boolean onLoad() throws Exception {
        if (Files.exists(this.path(), new LinkOption[0])) {
            Toml tomlReader = this.getDefaultToml();
            try (BufferedReader reader = Files.newBufferedReader(this.path());){
                this.setConfig(tomlReader.read((Reader)reader).to(this.configClass()));
            }
        }
        return true;
    }

    @NotNull
    private Toml getDefaultToml() {
        Toml toml = new Toml();
        return new Toml(toml.read(this.tomlWriter.write(this.defaultInstance())));
    }
}

