/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.config.api.instance.xjs;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.frozenblock.lib.config.api.instance.Config;
import net.frozenblock.lib.config.api.instance.xjs.XjsFormat;
import net.frozenblock.lib.config.api.instance.xjs.XjsObjectMapper;
import net.frozenblock.lib.shadow.xjs.data.JsonObject;
import net.frozenblock.lib.shadow.xjs.data.serialization.writer.ValueWriter;

public class XjsConfig<T>
extends Config<T> {
    private final XjsFormat format;

    public XjsConfig(String modId, Class<T> config) {
        this(modId, config, true);
    }

    public XjsConfig(String modId, Class<T> config, XjsFormat type) {
        this(modId, config, type, true);
    }

    public XjsConfig(String modId, Class<T> config, Path path, XjsFormat type) {
        this(modId, config, path, type, true);
    }

    public XjsConfig(String modId, Class<T> config, boolean supportsModification) {
        this(modId, config, XjsFormat.DJS_FORMATTED, supportsModification);
    }

    public XjsConfig(String modId, Class<T> config, XjsFormat type, boolean supportsModification) {
        this(modId, config, XjsConfig.makePath(modId, type.method_15434()), type, supportsModification);
    }

    public XjsConfig(String modId, Class<T> config, Path path, XjsFormat type, boolean supportsModification) {
        super(modId, config, path, supportsModification);
        this.format = type;
        if (this.load()) {
            this.save();
        }
    }

    @Override
    public void onSave() throws Exception {
        Files.createDirectories(this.path().getParent(), new FileAttribute[0]);
        JsonObject value = XjsObjectMapper.toJsonObject(this.instance());
        try (ValueWriter writer = this.format.createWriter(this.path().toFile());){
            writer.write(value);
        }
    }

    @Override
    public boolean onLoad() throws Exception {
        if (Files.exists(this.path(), new LinkOption[0])) {
            this.setConfig(XjsObjectMapper.deserializeObject(this.modId(), this.path(), this.configClass()));
        }
        return true;
    }
}

