/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.file.transfer;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.frozenblock.lib.file.transfer.FileTransferPacket;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FileTransferRebuilder {
    private static final Object2ObjectLinkedOpenHashMap<Path, ArrayList<FileTransferPacket.FileTransferSnippet>> SERVER_PENDING_RECEIVED_TRANSFERS = new Object2ObjectLinkedOpenHashMap();
    private static final Object2ObjectLinkedOpenHashMap<Path, ArrayList<FileTransferPacket.FileTransferSnippet>> CLIENT_PENDING_RECEIVED_TRANSFERS = new Object2ObjectLinkedOpenHashMap();

    public static boolean onReceiveFileTransferPacket(Path destinationPath, FileTransferPacket.FileTransferSnippet snippet, int totalPacketCount, boolean client) throws IOException {
        Object2ObjectLinkedOpenHashMap<Path, ArrayList<FileTransferPacket.FileTransferSnippet>> map = client ? CLIENT_PENDING_RECEIVED_TRANSFERS : SERVER_PENDING_RECEIVED_TRANSFERS;
        try {
            if (map.containsKey((Object)destinationPath)) {
                ArrayList snippets = (ArrayList)map.get((Object)destinationPath);
                snippets.add(snippet);
                if (snippet.index() == totalPacketCount) {
                    ArrayList finalBytes = new ArrayList();
                    snippets.forEach(snippetInList -> finalBytes.addAll(List.of(ArrayUtils.toObject((byte[])snippetInList.bytes()))));
                    FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(ArrayUtils.toPrimitive((Byte[])finalBytes.toArray(new Byte[0]))), (File)destinationPath.toFile());
                    map.remove((Object)destinationPath);
                    return true;
                }
            } else {
                if (snippet.index() == totalPacketCount) {
                    FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(snippet.bytes()), (File)destinationPath.toFile());
                    return true;
                }
                ArrayList<FileTransferPacket.FileTransferSnippet> snippets = new ArrayList<FileTransferPacket.FileTransferSnippet>();
                snippets.add(snippet);
                map.put((Object)destinationPath, snippets);
            }
        }
        catch (Exception e) {
            map.remove((Object)destinationPath);
            throw e;
        }
        return false;
    }
}

