/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.sound.client.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1106;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class FlyBySoundHub {
    private static final int PLAY_COOLDOWN = 40;
    private static final int MIN_DISTANCE_FOR_REMOVAL = 16;
    private static final double AUTO_ENTITY_DISTANCE = 3.0;
    private static final int AUTO_ENTITY_COOLDOWN = 1;
    private static final int PREDICTION_TICKS = 3;
    private static final double OVERALL_SENSITIVITY = 1.75;
    private static final double HORIZONTAL_SENSITIVITY = 1.0;
    private static final double VERTICAL_SENSITIVITY = 0.3;
    private static final double BASE_ENTITY_BOUNDING_BOX_EXPANSION = 0.7;
    private static final double BOUNDING_BOX_EXPANSION_PER_VELOCITY = 5.0;
    public static final Map<class_1299<?>, FlyBySound> AUTO_ENTITIES_AND_SOUNDS = new Object2ObjectOpenHashMap();
    public static final Map<class_1297, FlyBySound> FLYBY_ENTITIES_AND_SOUNDS = new Object2ObjectOpenHashMap();
    public static final Map<class_1297, Integer> ENTITY_COOLDOWNS = new Object2ObjectOpenHashMap();

    public static void tick(@NotNull class_310 client, class_1297 cameraEntity, boolean autoSounds) {
        if (client.field_1687 == null || cameraEntity == null || !client.field_1687.method_54719().method_54751()) {
            FLYBY_ENTITIES_AND_SOUNDS.clear();
            return;
        }
        class_243 cameraPos = cameraEntity.method_33571();
        double cameraEntityWidth = cameraEntity.method_17681();
        double detectionSize = cameraEntityWidth * 2.0;
        class_238 playerHeadBox = new class_238(cameraEntity.method_33571().method_1031(-detectionSize, -detectionSize, -detectionSize), cameraEntity.method_33571().method_1031(detectionSize, detectionSize, detectionSize));
        for (class_1297 entity : FLYBY_ENTITIES_AND_SOUNDS.keySet()) {
            if (entity == null) continue;
            class_243 entityVelocity = entity.method_30950(1.0f).method_1020(entity.method_30950(0.0f)).method_1021(1.75);
            entityVelocity = entityVelocity.method_18805(1.0, 0.3, 1.0);
            double entityVelocityLength = entityVelocity.method_1033();
            class_238 entityBox = entity.method_5829().method_1014(0.7 + entityVelocityLength * 5.0);
            if (!playerHeadBox.method_994(entityBox)) continue;
            class_243 entityPos = entity.method_30950(1.0f);
            int cooldown = ENTITY_COOLDOWNS.getOrDefault(entity, 0) - 1;
            ENTITY_COOLDOWNS.put(entity, cooldown);
            class_243 movedPos = entityPos.method_1019(entityVelocity.method_1021(3.0));
            if (!FlyBySoundHub.hasPassed(cameraPos, cameraEntityWidth, entityPos, movedPos) || cooldown > 0) continue;
            double deltaDistance = Math.abs(entityPos.method_1022(cameraPos) - movedPos.method_1022(cameraPos));
            FlyBySound flyBy = FLYBY_ENTITIES_AND_SOUNDS.get(entity);
            float volume = (float)((double)flyBy.volume + deltaDistance);
            client.method_1483().method_4873((class_1113)new class_1106(flyBy.sound, flyBy.category, volume, flyBy.pitch, entity, client.field_1687.field_9229.method_43055()));
            ENTITY_COOLDOWNS.put(entity, 40);
        }
        for (class_1297 entity : FLYBY_ENTITIES_AND_SOUNDS.keySet().stream().toList()) {
            if (entity != null && !entity.method_31481() && !entity.method_5701() && !(cameraPos.method_1022(entity.method_73189()) > 16.0)) continue;
            FLYBY_ENTITIES_AND_SOUNDS.remove(entity);
        }
        if (!AUTO_ENTITIES_AND_SOUNDS.isEmpty() && autoSounds) {
            class_238 box = new class_238(cameraPos.method_1031(-3.0, -3.0, -3.0), cameraPos.method_1031(3.0, 3.0, 3.0));
            for (class_1297 entity : client.field_1687.method_8335(cameraEntity, box)) {
                class_1299 type = entity.method_5864();
                if (!AUTO_ENTITIES_AND_SOUNDS.containsKey(type)) continue;
                FlyBySoundHub.addEntity(entity, AUTO_ENTITIES_AND_SOUNDS.get(type));
            }
        }
    }

    public static boolean hasPassed(@NotNull class_243 cameraPos, double cameraWidth, @NotNull class_243 oldCoord, @NotNull class_243 newCoord) {
        return FlyBySoundHub.hasPassedCoordinate(cameraPos.method_10216(), cameraWidth, 0.35, oldCoord.method_10216(), newCoord.method_10216()) || FlyBySoundHub.hasPassedCoordinate(cameraPos.method_10215(), cameraWidth, 0.35, oldCoord.method_10215(), newCoord.method_10215()) || FlyBySoundHub.hasPassedCoordinate(cameraPos.method_10214(), cameraWidth, 0.25, oldCoord.method_10214(), newCoord.method_10214());
    }

    public static boolean hasPassedCoordinate(double cameraCoord, double cameraWidth, double triggerWidth, double oldCoord, double newCoord) {
        double cameraTriggerWidth = cameraWidth * triggerWidth;
        double minCamera = cameraCoord - cameraWidth;
        double minCameraTrigger = cameraCoord - cameraTriggerWidth;
        double maxCamera = cameraCoord + cameraWidth;
        double maxCameraTrigger = cameraCoord + cameraTriggerWidth;
        if (oldCoord < minCamera) {
            return newCoord > minCameraTrigger;
        }
        if (oldCoord > maxCamera) {
            return newCoord < maxCameraTrigger;
        }
        return false;
    }

    public static void addEntity(class_1297 entity, FlyBySound flyBySound) {
        FLYBY_ENTITIES_AND_SOUNDS.put(entity, flyBySound);
    }

    public static void addEntityType(class_1299<?> type, FlyBySound flyBySound) {
        AUTO_ENTITIES_AND_SOUNDS.put(type, flyBySound);
    }

    public record FlyBySound(float pitch, float volume, class_3419 category, class_3414 sound) {
    }
}

