/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.block.client.api;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class LiquidRenderUtils {
    public static void tesselateWithSingleTexture(@NotNull class_1920 level, @NotNull class_2338 pos, class_4588 vertexConsumer, class_2680 blockState, class_3610 fluidState, class_1058 textureAtlasSprite) {
        float ap;
        float ao;
        float ag;
        float af;
        float ae;
        float ad;
        float ac;
        float ab;
        float z;
        float y;
        float southWestHeight;
        float southEastHeight;
        float northWestHeight;
        float northEastHeight;
        float f = 1.0f;
        float g = 1.0f;
        float h = 1.0f;
        class_2680 downBlockState = level.method_8320(pos.method_10093(class_2350.field_11033));
        class_3610 downFluidState = downBlockState.method_26227();
        class_2680 upBlockState = level.method_8320(pos.method_10093(class_2350.field_11036));
        class_3610 upFluidState = upBlockState.method_26227();
        class_2680 northBlockState = level.method_8320(pos.method_10093(class_2350.field_11043));
        class_3610 northFluidState = northBlockState.method_26227();
        class_2680 southBlockState = level.method_8320(pos.method_10093(class_2350.field_11035));
        class_3610 southFluidState = southBlockState.method_26227();
        class_2680 westBlockState = level.method_8320(pos.method_10093(class_2350.field_11039));
        class_3610 westFluidState = westBlockState.method_26227();
        class_2680 eastBlockState = level.method_8320(pos.method_10093(class_2350.field_11034));
        class_3610 eastFluidState = eastBlockState.method_26227();
        boolean shouldRenderUp = !LiquidRenderUtils.isNeighborSameFluidAndBlock(fluidState, upFluidState, blockState, upBlockState);
        boolean shouldRenderDown = LiquidRenderUtils.shouldRenderFace(level, pos, fluidState, blockState, class_2350.field_11033, downFluidState, downBlockState) && !LiquidRenderUtils.isFaceOccludedByNeighbor((class_1922)level, pos, class_2350.field_11033, 0.8888889f, downBlockState, blockState);
        boolean shouldRenderNorth = LiquidRenderUtils.shouldRenderFace(level, pos, fluidState, blockState, class_2350.field_11043, northFluidState, northBlockState);
        boolean bl5 = LiquidRenderUtils.shouldRenderFace(level, pos, fluidState, blockState, class_2350.field_11035, southFluidState, southBlockState);
        boolean bl6 = LiquidRenderUtils.shouldRenderFace(level, pos, fluidState, blockState, class_2350.field_11039, westFluidState, westBlockState);
        boolean bl7 = LiquidRenderUtils.shouldRenderFace(level, pos, fluidState, blockState, class_2350.field_11034, eastFluidState, eastBlockState);
        if (!(shouldRenderUp || shouldRenderDown || bl7 || bl6 || shouldRenderNorth || bl5)) {
            return;
        }
        float j = level.method_24852(class_2350.field_11033, true);
        float k = level.method_24852(class_2350.field_11036, true);
        float l = level.method_24852(class_2350.field_11043, true);
        float m = level.method_24852(class_2350.field_11039, true);
        class_3611 fluid = fluidState.method_15772();
        float n = LiquidRenderUtils.getHeight(level, fluid, pos, blockState, fluidState);
        if (n >= 1.0f) {
            northEastHeight = 1.0f;
            northWestHeight = 1.0f;
            southEastHeight = 1.0f;
            southWestHeight = 1.0f;
        } else {
            float s = LiquidRenderUtils.getHeight(level, fluid, pos.method_10095(), northBlockState, northFluidState);
            float t = LiquidRenderUtils.getHeight(level, fluid, pos.method_10072(), southBlockState, southFluidState);
            float u = LiquidRenderUtils.getHeight(level, fluid, pos.method_10078(), eastBlockState, eastFluidState);
            float v = LiquidRenderUtils.getHeight(level, fluid, pos.method_10067(), westBlockState, westFluidState);
            northEastHeight = LiquidRenderUtils.calculateAverageHeight(level, fluid, n, s, u, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11034));
            northWestHeight = LiquidRenderUtils.calculateAverageHeight(level, fluid, n, s, v, pos.method_10093(class_2350.field_11043).method_10093(class_2350.field_11039));
            southEastHeight = LiquidRenderUtils.calculateAverageHeight(level, fluid, n, t, u, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11034));
            southWestHeight = LiquidRenderUtils.calculateAverageHeight(level, fluid, n, t, v, pos.method_10093(class_2350.field_11035).method_10093(class_2350.field_11039));
        }
        float d = pos.method_10263() & 0xF;
        float e = pos.method_10264() & 0xF;
        float w = pos.method_10260() & 0xF;
        float f2 = y = shouldRenderDown ? 0.001f : 0.0f;
        if (shouldRenderUp && !LiquidRenderUtils.isFaceOccludedByNeighbor((class_1922)level, pos, class_2350.field_11036, Math.min(Math.min(northWestHeight, southWestHeight), Math.min(southEastHeight, northEastHeight)), upBlockState, blockState)) {
            northWestHeight -= 0.001f;
            southWestHeight -= 0.001f;
            southEastHeight -= 0.001f;
            northEastHeight -= 0.001f;
            z = textureAtlasSprite.method_4580(0.0f);
            float aa = textureAtlasSprite.method_4570(0.0f);
            ab = z;
            ac = textureAtlasSprite.method_4570(1.0f);
            ad = textureAtlasSprite.method_4580(1.0f);
            ae = ac;
            af = ad;
            ag = aa;
            float al = (z + ab + ad + af) / 4.0f;
            float ah = (aa + ac + ae + ag) / 4.0f;
            float ai = (float)textureAtlasSprite.method_45851().method_45807() / (textureAtlasSprite.method_4577() - textureAtlasSprite.method_4594());
            float aj = (float)textureAtlasSprite.method_45851().method_45815() / (textureAtlasSprite.method_4575() - textureAtlasSprite.method_4593());
            float ak = 4.0f / Math.max(aj, ai);
            z = class_3532.method_16439((float)ak, (float)z, (float)al);
            ab = class_3532.method_16439((float)ak, (float)ab, (float)al);
            ad = class_3532.method_16439((float)ak, (float)ad, (float)al);
            af = class_3532.method_16439((float)ak, (float)af, (float)al);
            aa = class_3532.method_16439((float)ak, (float)aa, (float)ah);
            ac = class_3532.method_16439((float)ak, (float)ac, (float)ah);
            ae = class_3532.method_16439((float)ak, (float)ae, (float)ah);
            ag = class_3532.method_16439((float)ak, (float)ag, (float)ah);
            int am = LiquidRenderUtils.getLightColor(level, pos);
            float an = k * f;
            ao = k * g;
            ap = k * h;
            LiquidRenderUtils.vertex(vertexConsumer, d + 0.0f, e + northWestHeight, w + 0.0f, an, ao, ap, z, aa, am);
            LiquidRenderUtils.vertex(vertexConsumer, d + 0.0f, e + southWestHeight, w + 1.0f, an, ao, ap, ab, ac, am);
            LiquidRenderUtils.vertex(vertexConsumer, d + 1.0f, e + southEastHeight, w + 1.0f, an, ao, ap, ad, ae, am);
            LiquidRenderUtils.vertex(vertexConsumer, d + 1.0f, e + northEastHeight, w + 0.0f, an, ao, ap, af, ag, am);
            if (fluidState.method_15756((class_1922)level, pos.method_10084()) || !blockState.equals(downBlockState)) {
                LiquidRenderUtils.vertex(vertexConsumer, d + 0.0f, e + northWestHeight, w + 0.0f, an, ao, ap, z, aa, am);
                LiquidRenderUtils.vertex(vertexConsumer, d + 1.0f, e + northEastHeight, w + 0.0f, an, ao, ap, af, ag, am);
                LiquidRenderUtils.vertex(vertexConsumer, d + 1.0f, e + southEastHeight, w + 1.0f, an, ao, ap, ad, ae, am);
                LiquidRenderUtils.vertex(vertexConsumer, d + 0.0f, e + southWestHeight, w + 1.0f, an, ao, ap, ab, ac, am);
            }
        }
        if (shouldRenderDown) {
            z = textureAtlasSprite.method_4594();
            ab = textureAtlasSprite.method_4577();
            ad = textureAtlasSprite.method_4593();
            af = textureAtlasSprite.method_4575();
            int aq = LiquidRenderUtils.getLightColor(level, pos.method_10074());
            ac = j * f;
            ae = j * g;
            ag = j * h;
            LiquidRenderUtils.vertex(vertexConsumer, d, e + y, w + 1.0f, ac, ae, ag, z, af, aq);
            LiquidRenderUtils.vertex(vertexConsumer, d, e + y, w, ac, ae, ag, z, ad, aq);
            LiquidRenderUtils.vertex(vertexConsumer, d + 1.0f, e + y, w, ac, ae, ag, ab, ad, aq);
            LiquidRenderUtils.vertex(vertexConsumer, d + 1.0f, e + y, w + 1.0f, ac, ae, ag, ab, af, aq);
            if (downBlockState.method_26204() != blockState.method_26204() && !downBlockState.method_26225()) {
                LiquidRenderUtils.vertex(vertexConsumer, d, e + y, w + 1.0f, ac, ae, ag, z, af, aq);
                LiquidRenderUtils.vertex(vertexConsumer, d + 1.0f, e + y, w + 1.0f, ac, ae, ag, z, ad, aq);
                LiquidRenderUtils.vertex(vertexConsumer, d + 1.0f, e + y, w, ac, ae, ag, ab, ad, aq);
                LiquidRenderUtils.vertex(vertexConsumer, d, e + y, w, ac, ae, ag, ab, af, aq);
            }
        }
        int ar = LiquidRenderUtils.getLightColor(level, pos);
        block5: for (class_2350 direction : class_2350.class_2353.field_11062) {
            float av;
            float au;
            float at;
            float as;
            float aa;
            switch (direction) {
                case field_11043: {
                    af = northWestHeight;
                    aa = northEastHeight;
                    as = d;
                    at = d + 1.0f;
                    au = w + 0.001f;
                    av = w + 0.001f;
                    if (!shouldRenderNorth) continue block5;
                    break;
                }
                case field_11035: {
                    af = southEastHeight;
                    aa = southWestHeight;
                    as = d + 1.0f;
                    at = d;
                    au = w + 1.0f - 0.001f;
                    av = w + 1.0f - 0.001f;
                    if (!bl5) continue block5;
                    break;
                }
                case field_11039: {
                    af = southWestHeight;
                    aa = northWestHeight;
                    as = d + 0.001f;
                    at = d + 0.001f;
                    au = w + 1.0f;
                    av = w;
                    if (!bl6) continue block5;
                    break;
                }
                default: {
                    af = northEastHeight;
                    aa = southEastHeight;
                    as = d + 1.0f - 0.001f;
                    at = d + 1.0f - 0.001f;
                    au = w;
                    av = w + 1.0f;
                    if (!bl7) continue block5;
                }
            }
            if (LiquidRenderUtils.isFaceOccludedByNeighbor((class_1922)level, pos, direction, Math.max(af, aa), level.method_8320(pos.method_10093(direction)), level.method_8320(pos.method_10093(direction)))) continue;
            ao = textureAtlasSprite.method_4580(0.0f);
            ap = textureAtlasSprite.method_4580(1.0f);
            float aw = textureAtlasSprite.method_4570(0.0f);
            float ax = textureAtlasSprite.method_4570(0.0f);
            float ay = textureAtlasSprite.method_4570(1.0f);
            float az = direction.method_10166() == class_2350.class_2351.field_11051 ? l : m;
            float ba = k * az * f;
            float bb = k * az * g;
            float bc = k * az * h;
            LiquidRenderUtils.vertex(vertexConsumer, as, e + af, au, ba, bb, bc, ao, aw, ar);
            LiquidRenderUtils.vertex(vertexConsumer, at, e + aa, av, ba, bb, bc, ap, ax, ar);
            LiquidRenderUtils.vertex(vertexConsumer, at, e + y, av, ba, bb, bc, ap, ay, ar);
            LiquidRenderUtils.vertex(vertexConsumer, as, e + y, au, ba, bb, bc, ao, ay, ar);
            LiquidRenderUtils.vertex(vertexConsumer, as, e + y, au, ba, bb, bc, ao, ay, ar);
            LiquidRenderUtils.vertex(vertexConsumer, at, e + y, av, ba, bb, bc, ap, ay, ar);
            LiquidRenderUtils.vertex(vertexConsumer, at, e + aa, av, ba, bb, bc, ap, ax, ar);
            LiquidRenderUtils.vertex(vertexConsumer, as, e + af, au, ba, bb, bc, ao, aw, ar);
        }
    }

    private static float calculateAverageHeight(class_1920 world, class_3611 fluid, float height, float adjacentHeightA, float adjacentHeightB, class_2338 fluidPos) {
        if (adjacentHeightB >= 1.0f || adjacentHeightA >= 1.0f) {
            return 1.0f;
        }
        float[] fs = new float[2];
        if (adjacentHeightB > 0.0f || adjacentHeightA > 0.0f) {
            float f = LiquidRenderUtils.getHeight(world, fluid, fluidPos);
            if (f >= 1.0f) {
                return 1.0f;
            }
            LiquidRenderUtils.addWeightedHeight(fs, f);
        }
        LiquidRenderUtils.addWeightedHeight(fs, height);
        LiquidRenderUtils.addWeightedHeight(fs, adjacentHeightB);
        LiquidRenderUtils.addWeightedHeight(fs, adjacentHeightA);
        return fs[0] / fs[1];
    }

    public static void addWeightedHeight(float[] weights, float height) {
        if (height >= 0.8f) {
            weights[0] = weights[0] + height * 10.0f;
            weights[1] = weights[1] + 10.0f;
        } else if (height >= 0.0f) {
            weights[0] = weights[0] + height;
            weights[1] = weights[1] + 1.0f;
        }
    }

    public static float getHeight(@NotNull class_1920 world, class_3611 fluid, class_2338 blockState) {
        class_2680 blockState2 = world.method_8320(blockState);
        return LiquidRenderUtils.getHeight(world, fluid, blockState, blockState2, blockState2.method_26227());
    }

    public static float getHeight(class_1920 world, @NotNull class_3611 fluid, class_2338 pos, class_2680 blockState, @NotNull class_3610 state) {
        if (fluid.method_15780(state.method_15772())) {
            class_2680 blockState2 = world.method_8320(pos.method_10084());
            if (fluid.method_15780(blockState2.method_26227().method_15772())) {
                return 1.0f;
            }
            return state.method_20785();
        }
        if (!blockState.method_51367()) {
            return 0.0f;
        }
        return -1.0f;
    }

    public static void vertex(@NotNull class_4588 consumer, float x, float y, float z, float red, float green, float blue, float u, float v, int packedLight) {
        consumer.method_22912(x, y, z).method_22915(red, green, blue, 1.0f).method_22913(u, v).method_60803(packedLight).method_22914(0.0f, 1.0f, 0.0f);
    }

    public static int getLightColor(class_1920 level, class_2338 pos) {
        int i = class_761.method_23794((class_1920)level, (class_2338)pos);
        int j = class_761.method_23794((class_1920)level, (class_2338)pos.method_10084());
        int k = i & 0xFF;
        int l = j & 0xFF;
        int m = i >> 16 & 0xFF;
        int n = j >> 16 & 0xFF;
        return Math.max(k, l) | Math.max(m, n) << 16;
    }

    private static boolean isNeighborSameFluidAndBlock(@NotNull class_3610 firstState, @NotNull class_3610 secondState, class_2680 firstBlock, class_2680 secondBlock) {
        return secondState.method_15772().method_15780(firstState.method_15772()) && firstBlock.method_26204() == secondBlock.method_26204();
    }

    private static boolean isFaceOccludedByState(class_1922 level, class_2350 face, float height, class_2338 pos, @NotNull class_2680 state, @NotNull class_2680 neighborState) {
        if (neighborState.method_26204() == state.method_26204() && state.method_26225()) {
            class_265 voxelShape = class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)height, (double)1.0);
            class_265 voxelShape2 = state.method_26201();
            return class_259.method_1083((class_265)voxelShape, (class_265)voxelShape2, (class_2350)face);
        }
        return false;
    }

    private static boolean isFaceOccludedByNeighbor(class_1922 level, @NotNull class_2338 pos, class_2350 side, float height, class_2680 blockState, class_2680 neighborState) {
        return LiquidRenderUtils.isFaceOccludedByState(level, side, height, pos.method_10093(side), blockState, neighborState);
    }

    private static boolean isFaceOccludedBySelf(class_1922 level, class_2338 pos, class_2680 state, @NotNull class_2350 face, class_2680 neighborState) {
        return LiquidRenderUtils.isFaceOccludedByState(level, face.method_10153(), 1.0f, pos, state, neighborState);
    }

    public static boolean shouldRenderFace(class_1920 level, class_2338 pos, class_3610 fluidState, class_2680 blockState, class_2350 side, class_3610 neighborFluid, class_2680 neighborState) {
        return !LiquidRenderUtils.isFaceOccludedBySelf((class_1922)level, pos, blockState, side, neighborState) && !LiquidRenderUtils.isNeighborSameFluidAndBlock(fluidState, neighborFluid, blockState, neighborState);
    }
}

