/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.particle.client;

import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class CustomRotationalParticleRenderer {
    private static final Vector3f NORMALIZED_QUAT_VECTOR = new Vector3f(0.5f, 0.5f, 0.5f).normalize();
    private float prevXRot;
    private float xRot;
    private float prevYRot;
    private float yRot;
    private float prevRotMultiplier;
    private float rotMultiplier;
    private boolean flipped;

    public void setPrevRotationFromCurrent() {
        this.prevYRot = this.yRot;
        this.prevXRot = this.xRot;
    }

    public void setRotation(float yRot, float xRot) {
        this.yRot = yRot;
        this.xRot = xRot;
        this.setRotMultiplierFromXRot();
    }

    public void setRotationFromMovement(double xd, double yd, double zd, float rotationAmount) {
        double horizontalDistance = Math.sqrt(xd * xd + zd * zd);
        double newYRot = class_3532.method_15349((double)xd, (double)zd) * 57.2957763671875;
        double newXRot = class_3532.method_15349((double)horizontalDistance, (double)yd) * 57.2957763671875;
        double newYRotDifference = class_3532.method_15338((double)(newYRot - (double)this.yRot));
        double newXRotDifference = class_3532.method_15338((double)(newXRot - (double)this.xRot));
        this.yRot += (float)newYRotDifference * rotationAmount;
        this.xRot += (float)newXRotDifference * rotationAmount;
        while (this.yRot - this.prevYRot < -180.0f) {
            this.prevYRot -= 360.0f;
        }
        while (this.yRot - this.prevYRot >= 180.0f) {
            this.prevYRot += 360.0f;
        }
        while (this.xRot - this.prevXRot < -180.0f) {
            this.prevXRot -= 360.0f;
        }
        while (this.xRot - this.prevXRot >= 180.0f) {
            this.prevXRot += 360.0f;
        }
        this.setRotMultiplierFromXRot();
    }

    private void setRotMultiplierFromXRot() {
        this.prevRotMultiplier = this.rotMultiplier;
        this.rotMultiplier = class_3532.method_15374((float)(this.xRot * (float)Math.PI / 180.0f));
    }

    public void setFlipped(boolean flipped) {
        this.flipped = flipped;
    }

    private static float[] getUVMapping(float U0, float U1, float V0, float V1, boolean flipped) {
        return new float[]{flipped ? U1 : U0, flipped ? U0 : U1, V0, V1};
    }

    public void render(@NotNull class_4588 buffer, @NotNull class_4184 camera, double x, double y, double z, double xd, double yd, double zd, float U0, float U1, float V0, float V1, float quadSize, float rCol, float gCol, float bCol, float alpha, int light, float partialTicks) {
        float yRot = class_3532.method_16439((float)partialTicks, (float)this.prevYRot, (float)this.yRot) * ((float)Math.PI / 180);
        float xRot = class_3532.method_16439((float)partialTicks, (float)this.prevXRot, (float)this.xRot) * ((float)(-Math.PI) / 180);
        float cameraRotWhileVertical = -camera.method_19330() * (1.0f - class_3532.method_16439((float)partialTicks, (float)this.prevRotMultiplier, (float)this.rotMultiplier)) * ((float)Math.PI / 180);
        float cameraXRot = camera.method_19329();
        class_243 particlePos = new class_243(x, y, z);
        class_243 cameraPos = camera.method_19326();
        double normalizedRelativeY = particlePos.method_1020((class_243)cameraPos).method_1029().method_1020((class_243)new class_243((double)xd, (double)yd, (double)zd).method_1029()).method_1029().field_1351;
        double particleRotation = AdvancedMath.getAngleFromOriginXZ(new class_243(xd, 0.0, zd));
        double angleToParticle = AdvancedMath.getAngleBetweenXZ(particlePos, cameraPos);
        double relativeParticleAngle = (360.0 + (angleToParticle - particleRotation)) % 360.0;
        if (normalizedRelativeY > 0.0) {
            cameraXRot = class_3532.method_16439((float)class_3532.method_27285((float)((float)normalizedRelativeY)), (float)cameraXRot, (float)-90.0f);
        } else if (normalizedRelativeY < 0.0) {
            cameraXRot = class_3532.method_16439((float)class_3532.method_27285((float)((float)Math.abs(normalizedRelativeY))), (float)cameraXRot, (float)90.0f);
        }
        float fixedRotation = 90.0f + cameraXRot;
        if (relativeParticleAngle > 0.0 && relativeParticleAngle < 180.0) {
            fixedRotation *= -1.0f;
        }
        float cameraRotWhileSideways = fixedRotation * class_3532.method_16439((float)partialTicks, (float)this.prevRotMultiplier, (float)this.rotMultiplier) * ((float)Math.PI / 180);
        this.renderParticle(buffer, cameraPos, particlePos, quadSize, rCol, gCol, bCol, alpha, light, transforms -> transforms.rotateY(yRot).rotateX(-xRot).rotateY(cameraRotWhileSideways).rotateY(cameraRotWhileVertical), CustomRotationalParticleRenderer.getUVMapping(U0, U1, V0, V1, this.flipped));
        this.renderParticle(buffer, cameraPos, particlePos, quadSize, rCol, gCol, bCol, alpha, light, transforms -> transforms.rotateY((float)(-Math.PI) + yRot).rotateX(xRot).rotateY(cameraRotWhileSideways).rotateY(cameraRotWhileVertical), CustomRotationalParticleRenderer.getUVMapping(U0, U1, V0, V1, !this.flipped));
    }

    private void renderParticle(class_4588 buffer, @NotNull class_243 cameraPos, class_243 particlePos, float quadSize, float rCol, float gCol, float bCol, float alpha, int light, @NotNull Consumer<Quaternionf> quaternionConsumer, float[] uvMapping) {
        float xDifference = (float)(particlePos.method_10216() - cameraPos.method_10216());
        float yDifference = (float)(particlePos.method_10214() - cameraPos.method_10214());
        float zDifference = (float)(particlePos.method_10215() - cameraPos.method_10215());
        Quaternionf quaternionf = new Quaternionf().setAngleAxis(0.0f, NORMALIZED_QUAT_VECTOR.x(), NORMALIZED_QUAT_VECTOR.y(), NORMALIZED_QUAT_VECTOR.z());
        quaternionConsumer.accept(quaternionf);
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        for (int j = 0; j < 4; ++j) {
            Vector3f vector3f2 = vector3fs[j];
            vector3f2.rotate((Quaternionfc)quaternionf);
            vector3f2.mul(quadSize);
            vector3f2.add(xDifference, yDifference, zDifference);
        }
        buffer.method_22912(vector3fs[0].x(), vector3fs[0].y(), vector3fs[0].z()).method_22913(uvMapping[1], uvMapping[3]).method_22915(rCol, gCol, bCol, alpha).method_60803(light);
        buffer.method_22912(vector3fs[1].x(), vector3fs[1].y(), vector3fs[1].z()).method_22913(uvMapping[1], uvMapping[2]).method_22915(rCol, gCol, bCol, alpha).method_60803(light);
        buffer.method_22912(vector3fs[2].x(), vector3fs[2].y(), vector3fs[2].z()).method_22913(uvMapping[0], uvMapping[2]).method_22915(rCol, gCol, bCol, alpha).method_60803(light);
        buffer.method_22912(vector3fs[3].x(), vector3fs[3].y(), vector3fs[3].z()).method_22913(uvMapping[0], uvMapping[3]).method_22915(rCol, gCol, bCol, alpha).method_60803(light);
    }
}

