/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.screenshake.api;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.frozenblock.lib.FrozenLibConstants;
import net.frozenblock.lib.screenshake.impl.EntityScreenShakeInterface;
import net.frozenblock.lib.screenshake.impl.ScreenShakeManagerInterface;
import net.frozenblock.lib.screenshake.impl.ScreenShakeStorage;
import net.frozenblock.lib.screenshake.impl.network.EntityScreenShakePacket;
import net.frozenblock.lib.screenshake.impl.network.ScreenShakePacket;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_8710;
import org.jetbrains.annotations.NotNull;
import org.slf4j.helpers.NOPLogger;

public class ScreenShakeManager {
    private final ArrayList<ScreenShake> shakes = new ArrayList();
    private final class_3218 level;

    public ScreenShakeManager(class_3218 level) {
        this.level = level;
    }

    public static ScreenShakeManager getScreenShakeManager(class_3218 level) {
        return ((ScreenShakeManagerInterface)level).frozenLib$getScreenShakeManager();
    }

    public static void addScreenShake(class_1937 level, float intensity, double x, double y, double z, float maxDistance) {
        ScreenShakeManager.addScreenShake(level, intensity, 20, 5, x, y, z, maxDistance);
    }

    public static void addScreenShake(class_1937 level, float intensity, int duration, double x, double y, double z, float maxDistance) {
        ScreenShakeManager.addScreenShake(level, intensity, duration, 1, x, y, z, maxDistance);
    }

    public static void addScreenShake(class_1937 level, float intensity, int duration, int falloffStart, double x, double y, double z, float maxDistance) {
        ScreenShakeManager.addScreenShake(level, intensity, duration, falloffStart, x, y, z, maxDistance, 0);
    }

    public static void addScreenShake(@NotNull class_1937 level, float intensity, int duration, int falloffStart, double x, double y, double z, float maxDistance, int ticks) {
        if (!level.field_9236) {
            class_3218 serverLevel = (class_3218)level;
            ScreenShakeManager.getScreenShakeManager(serverLevel).addShake(intensity, duration, falloffStart, new class_243(x, y, z), maxDistance, ticks);
        }
    }

    public static void sendScreenShakePacketTo(class_3222 player, float intensity, int duration, int falloffStart, class_243 pos, float maxDistance, int ticks) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ScreenShakePacket(intensity, duration, falloffStart, pos, maxDistance, ticks));
    }

    public static void addEntityScreenShake(class_1297 entity, float intensity, float maxDistance) {
        ScreenShakeManager.addEntityScreenShake(entity, intensity, 5, 1, maxDistance);
    }

    public static void addEntityScreenShake(class_1297 entity, float intensity, int duration, float maxDistance) {
        ScreenShakeManager.addEntityScreenShake(entity, intensity, duration, 1, maxDistance);
    }

    public static void addEntityScreenShake(class_1297 entity, float intensity, int duration, int falloffStart, float maxDistance) {
        ScreenShakeManager.addEntityScreenShake(entity, intensity, duration, falloffStart, maxDistance, 0);
    }

    public static void addEntityScreenShake(@NotNull class_1297 entity, float intensity, int duration, int falloffStart, float maxDistance, int ticks) {
        class_1937 class_19372 = entity.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            EntityScreenShakePacket packet = new EntityScreenShakePacket(entity.method_5628(), intensity, duration, falloffStart, maxDistance, ticks);
            for (class_3222 player : PlayerLookup.world((class_3218)serverLevel)) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
            }
            ((EntityScreenShakeInterface)entity).frozenLib$addScreenShake(intensity, duration, falloffStart, maxDistance, ticks);
        }
    }

    public static void sendEntityScreenShakeTo(class_3222 player, @NotNull class_1297 entity, float intensity, int duration, int falloffStart, float maxDistance, int ticks) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new EntityScreenShakePacket(entity.method_5628(), intensity, duration, falloffStart, maxDistance, ticks));
    }

    public void tick(@NotNull class_3218 level) {
        if (level.method_54719().method_54751()) {
            this.getShakes().removeIf(ScreenShake::shouldRemove);
            for (ScreenShake shake : this.getShakes()) {
                if (!this.level.method_14178().method_12123(shake.chunkPos.field_9181, shake.chunkPos.field_9180)) continue;
                ++shake.ticks;
                Collection playersTrackingChunk = PlayerLookup.tracking((class_3218)this.level, (class_1923)shake.chunkPos);
                for (class_3222 serverPlayer : playersTrackingChunk) {
                    if (shake.trackingPlayers.contains(serverPlayer)) continue;
                    ScreenShakeManager.sendScreenShakePacketTo(serverPlayer, shake.getIntensity(), shake.getDuration(), shake.getDurationFalloffStart(), shake.getPos(), shake.getMaxDistance(), shake.getTicks());
                }
                shake.trackingPlayers.clear();
                shake.trackingPlayers.addAll(playersTrackingChunk);
            }
        }
    }

    public void addShake(float intensity, int duration, int falloffStart, class_243 pos, float maxDistance, int ticks) {
        this.getShakes().add(new ScreenShake(intensity, duration, falloffStart, pos, maxDistance, ticks));
    }

    public void load(@NotNull class_2487 nbt) {
        if (nbt.method_10573("ScreenShakes", 9)) {
            this.getShakes().clear();
            ScreenShake.LIST_CODEC.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)nbt.method_10554("ScreenShakes", 10))).resultOrPartial(arg_0 -> ((NOPLogger)FrozenLibConstants.LOGGER4).error(arg_0)).ifPresent(this.getShakes()::addAll);
        }
    }

    public void save(class_2487 nbt) {
        ScreenShake.LIST_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.shakes).resultOrPartial(arg_0 -> ((NOPLogger)FrozenLibConstants.LOGGER4).error(arg_0)).ifPresent(cursorsNbt -> nbt.method_10566("ScreenShakes", cursorsNbt));
    }

    public class_18.class_8645<ScreenShakeStorage> createData() {
        return new class_18.class_8645(() -> new ScreenShakeStorage(this), (tag, provider) -> ScreenShakeStorage.load(tag, this), class_4284.field_45082);
    }

    @Generated
    public ArrayList<ScreenShake> getShakes() {
        return this.shakes;
    }

    public static class ScreenShake {
        public static final Codec<ScreenShake> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("Intensity").forGetter(ScreenShake::getIntensity), (App)Codec.INT.fieldOf("Duration").forGetter(ScreenShake::getDuration), (App)Codec.INT.fieldOf("FalloffStart").forGetter(ScreenShake::getDurationFalloffStart), (App)class_243.field_38277.fieldOf("Position").forGetter(ScreenShake::getPos), (App)Codec.FLOAT.fieldOf("MaxDistance").forGetter(ScreenShake::getMaxDistance), (App)Codec.INT.fieldOf("Ticks").forGetter(ScreenShake::getTicks)).apply((Applicative)instance, ScreenShake::new));
        public static final Codec<List<ScreenShake>> LIST_CODEC = CODEC.listOf();
        public final int duration;
        public final float maxDistance;
        public final class_1923 chunkPos;
        private final float intensity;
        private final int durationFalloffStart;
        public int ticks;
        public List<class_3222> trackingPlayers = new ArrayList<class_3222>();
        protected class_243 pos;

        public ScreenShake(float intensity, int duration, int durationFalloffStart, class_243 pos, float maxDistance, int ticks) {
            this.intensity = intensity;
            this.duration = duration;
            this.durationFalloffStart = durationFalloffStart;
            this.pos = pos;
            this.maxDistance = maxDistance;
            this.ticks = ticks;
            this.chunkPos = new class_1923(class_2338.method_49638((class_2374)pos));
        }

        public boolean shouldRemove() {
            return this.ticks > this.duration;
        }

        @Generated
        public int getDuration() {
            return this.duration;
        }

        @Generated
        public float getMaxDistance() {
            return this.maxDistance;
        }

        @Generated
        public float getIntensity() {
            return this.intensity;
        }

        @Generated
        public int getDurationFalloffStart() {
            return this.durationFalloffStart;
        }

        @Generated
        public int getTicks() {
            return this.ticks;
        }

        @Generated
        public class_243 getPos() {
            return this.pos;
        }
    }
}

