/*
 * Decompiled with CFR 0.152.
 */
package org.quiltmc.qsl.frozenblock.misc.datafixerupper.impl;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_4284;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.impl.QuiltDataFixesInternals;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.mixin.DataFixTypesAccessor;

@ApiStatus.Internal
public final class QuiltDataFixesInternalsImpl
extends QuiltDataFixesInternals {
    @NotNull
    private final Schema latestVanillaSchema;
    private Map<String, QuiltDataFixesInternals.DataFixerEntry> modDataFixers;
    private Map<String, QuiltDataFixesInternals.DataFixerEntry> modMinecraftDataFixers;
    private boolean frozen;

    public QuiltDataFixesInternalsImpl(@NotNull Schema latestVanillaSchema) {
        this.latestVanillaSchema = latestVanillaSchema;
        this.modDataFixers = new Object2ReferenceOpenHashMap();
        this.modMinecraftDataFixers = new Object2ReferenceOpenHashMap();
        this.frozen = false;
    }

    @Override
    public void registerFixer(@NotNull String modId, @Range(from=0L, to=0x7FFFFFFFL) int currentVersion, @NotNull DataFixer dataFixer) {
        if (this.modDataFixers.containsKey(modId)) {
            throw new IllegalArgumentException("Mod '" + modId + "' already has a registered data fixer");
        }
        this.modDataFixers.put(modId, new QuiltDataFixesInternals.DataFixerEntry(dataFixer, currentVersion));
    }

    @Override
    public boolean isEmpty() {
        return this.modDataFixers.isEmpty() && this.modMinecraftDataFixers.isEmpty();
    }

    @Override
    @Nullable
    public QuiltDataFixesInternals.DataFixerEntry getFixerEntry(@NotNull String modId) {
        return this.modDataFixers.get(modId);
    }

    @Override
    public void registerMinecraftFixer(@NotNull String modId, @Range(from=0L, to=0x7FFFFFFFL) int currentVersion, @NotNull DataFixer dataFixer) {
        if (this.modMinecraftDataFixers.containsKey(modId)) {
            throw new IllegalArgumentException("Mod '" + modId + "' already has a registered Minecraft-version-based data fixer");
        }
        this.modMinecraftDataFixers.put(modId, new QuiltDataFixesInternals.DataFixerEntry(dataFixer, currentVersion));
    }

    @Override
    @Nullable
    public QuiltDataFixesInternals.DataFixerEntry getMinecraftFixerEntry(@NotNull String modId) {
        return this.modMinecraftDataFixers.get(modId);
    }

    @Override
    @NotNull
    public Schema createBaseSchema() {
        return new Schema(0, this.latestVanillaSchema);
    }

    @Override
    @NotNull
    public Dynamic<class_2520> updateWithAllFixers(@NotNull class_4284 dataFixTypes, @NotNull Dynamic<class_2520> current) {
        QuiltDataFixesInternals.DataFixerEntry dataFixerEntry;
        OptionalInt modDataVersion;
        class_2487 compound = (class_2487)current.getValue();
        for (Map.Entry<String, QuiltDataFixesInternals.DataFixerEntry> entry : this.modMinecraftDataFixers.entrySet()) {
            modDataVersion = QuiltDataFixesInternalsImpl.getModMinecraftDataVersion(compound, entry.getKey());
            dataFixerEntry = entry.getValue();
            if (!modDataVersion.isPresent()) continue;
            current = dataFixerEntry.dataFixer().update(((DataFixTypesAccessor)DataFixTypesAccessor.class.cast(dataFixTypes)).getType(), current, modDataVersion.getAsInt(), dataFixerEntry.currentVersion());
        }
        for (Map.Entry<String, QuiltDataFixesInternals.DataFixerEntry> entry : this.modDataFixers.entrySet()) {
            modDataVersion = QuiltDataFixesInternalsImpl.getModDataVersion(compound, entry.getKey());
            dataFixerEntry = entry.getValue();
            if (!modDataVersion.isPresent()) continue;
            current = dataFixerEntry.dataFixer().update(((DataFixTypesAccessor)DataFixTypesAccessor.class.cast(dataFixTypes)).getType(), current, modDataVersion.getAsInt(), dataFixerEntry.currentVersion());
        }
        return current;
    }

    @Override
    @NotNull
    public class_2487 addModDataVersions(@NotNull class_2487 compound) {
        for (Map.Entry<String, QuiltDataFixesInternals.DataFixerEntry> entry : this.modDataFixers.entrySet()) {
            compound.method_10569(entry.getKey() + "_DataVersion", entry.getValue().currentVersion());
        }
        for (Map.Entry<String, QuiltDataFixesInternals.DataFixerEntry> entry : this.modMinecraftDataFixers.entrySet()) {
            compound.method_10569(entry.getKey() + "_DataVersion_Minecraft", entry.getValue().currentVersion());
        }
        return compound;
    }

    @Override
    public void freeze() {
        if (!this.frozen) {
            this.modDataFixers = Collections.unmodifiableMap(this.modDataFixers);
            this.modMinecraftDataFixers = Collections.unmodifiableMap(this.modMinecraftDataFixers);
        }
        this.frozen = true;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }
}

