/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.event.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.loader.api.FabricLoader;
import net.frozenblock.lib.event.impl.EventType;

public class FrozenEvents {
    private static final List<Event<?>> REGISTERED_EVENTS = new ArrayList();

    public static <T> Event<T> createEnvironmentEvent(Class<? super T> type, Function<T[], T> invokerFactory) {
        Event event = EventFactory.createArrayBacked(type, invokerFactory);
        FrozenEvents.register(event, type);
        return event;
    }

    public static <T> Event<T> createEnvironmentEvent(Class<T> type, T emptyInvoker, Function<T[], T> invokerFactory) {
        Event event = EventFactory.createArrayBacked(type, emptyInvoker, invokerFactory);
        FrozenEvents.register(event, type);
        return event;
    }

    public static <T> void register(Event<T> event, Class<? super T> type) {
        if (REGISTERED_EVENTS.contains(event)) {
            return;
        }
        REGISTERED_EVENTS.add(event);
        for (EventType eventType : EventType.VALUES) {
            if (!eventType.listener().isAssignableFrom(type)) continue;
            List entrypoints = FabricLoader.getInstance().getEntrypoints(eventType.entrypoint(), eventType.listener());
            for (Object entrypoint : entrypoints) {
                if (!type.isAssignableFrom(entrypoint.getClass())) continue;
                event.register(Event.DEFAULT_PHASE, entrypoint);
            }
        }
    }
}

