/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.music.api.client.structure;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.music.api.client.structure.StructureMusic;
import net.frozenblock.lib.worldgen.structure.api.status.client.ClientStructureStatuses;
import net.frozenblock.lib.worldgen.structure.impl.status.PlayerStructureStatus;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class StructureMusicApi {
    private static final Map<class_2960, List<StructureMusic>> STRUCTURE_TO_MUSIC_MAP = new Object2ObjectLinkedOpenHashMap();

    public static void registerMusicForStructure(class_2960 structureLocation, StructureMusic music) {
        List musicList = STRUCTURE_TO_MUSIC_MAP.computeIfAbsent(structureLocation, location -> new ArrayList());
        musicList.add(music);
        STRUCTURE_TO_MUSIC_MAP.put(structureLocation, musicList);
    }

    public static void registerMusicForStructure(@NotNull class_5321<class_3195> structureKey, StructureMusic music) {
        StructureMusicApi.registerMusicForStructure(structureKey.method_29177(), music);
    }

    @ApiStatus.Internal
    @NotNull
    private static Optional<class_5195> getCurrentStructureMusic(class_5819 random) {
        Optional<PlayerStructureStatus> optionalStructureStatus = ClientStructureStatuses.getProminentStructureStatus();
        if (optionalStructureStatus.isEmpty()) {
            return Optional.empty();
        }
        PlayerStructureStatus structureStatus = optionalStructureStatus.get();
        boolean isInsidePiece = structureStatus.isInsidePiece();
        List structureMusicList = STRUCTURE_TO_MUSIC_MAP.getOrDefault(structureStatus.getStructure(), List.of());
        ArrayList<StructureMusic> finalizedStructureMusicList = new ArrayList<StructureMusic>();
        for (StructureMusic structureMusic : structureMusicList) {
            if (!isInsidePiece && structureMusic.mustBeInsidePiece()) continue;
            finalizedStructureMusicList.add(structureMusic);
        }
        if (!finalizedStructureMusicList.isEmpty()) {
            return Optional.of(((StructureMusic)class_156.method_32309(finalizedStructureMusicList, (class_5819)random)).music());
        }
        return Optional.empty();
    }

    @ApiStatus.Internal
    @NotNull
    public static class_5195 chooseMusicOrStructureMusic(@Nullable class_746 player, class_5195 music) {
        if (player == null) {
            return music;
        }
        return StructureMusicApi.getCurrentStructureMusic(player.method_59922()).orElse(music);
    }
}

